/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestDetailedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedPrincipal;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedUser;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalSearchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.user.AbstractPermissionResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/permissions")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Permission Management")
public class RepositoryPermissionResource
extends AbstractPermissionResource {
    @Inject
    public RepositoryPermissionResource(DmzPermissionAdminService permissionAdminService, UserService userService, I18nService i18nService) {
        super(i18nService, permissionAdminService, userService);
    }

    @Operation(description="Retrieve a page of groups that have been granted at least one permission for the specified repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource.", summary="Get groups with permission to repository")
    @Parameter(description="If specified only group names containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups and their highest permissions for the specified repository.", paged=true, representation=RestPermittedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroupsWithAnyPermission(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findGroupsWithRepositoryPermission(repositoryResolver.getRepository(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPermittedGroup.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of groups that have no granted permissions for the specified repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource.", summary="Get groups without repository permission")
    @Parameter(description="If specified only group names containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups that have not been granted any permissions for the specified repository.", paged=true, representation=RestDetailedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="groups/none")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroupsWithoutAnyPermission(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findGroupsWithoutRepositoryPermission(repositoryResolver.getRepository(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedGroup.NAME_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of users that have been granted at least one permission for the specified repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource.", summary="Get users with permission to repository")
    @Parameter(description="If specified only user names containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users and their highest permissions for the specified repository.", paged=true, representation=RestPermittedUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsersWithAnyPermission(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findUsersWithRepositoryPermission(repositoryResolver.getRepository(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPermittedUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of <i>licensed</i> users that have no granted permissions for the specified repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource.", summary="Get users without repository permission")
    @Parameter(description="If specified only user names containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users that have not been granted any permissions for the specified repository.", paged=true, representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="users/none")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsersWithoutPermission(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findLicensedUsersWithoutRepositoryPermission(repositoryResolver.getRepository(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Promote or demote a group's permission level for the specified repository. Available repository permissions are:\n\n- REPO_READ\n- REPO_WRITE\n- REPO_ADMIN\n\n\nSee the <a href=\"https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions\">Bitbucket Data Center documentation</a> for a detailed explanation of what each permission entails.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource. In addition, a user may not demote a group's permission level if their own permission level would be reduced as a result.", summary="Update group repository permission")
    @Parameters(value={@Parameter(description="The names of the groups.", in=ParameterIn.QUERY, name="name", array=@ArraySchema(schema=@Schema(type="string")), required=true), @Parameter(description="The permission to grant", in=ParameterIn.QUERY, name="permission", schema=@Schema(allowableValues={"REPO_READ", "REPO_WRITE", "REPO_ADMIN"}), required=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested permission was granted.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's permission level.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPermissionForGroup(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="permission") String permissionName, @QueryParam(value="name") Set<String> groupNames) {
        Permission permission = this.validatePermission(permissionName, Repository.class);
        Set<String> groups = this.validateGroups(groupNames);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repositoryResolver.getRepository()).groups(groups).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Promote or demote a user's permission level for the specified repository. Available repository permissions are:\n\n- REPO_READ</li>- REPO_WRITE</li>- REPO_ADMIN</li></ul>See the <a href=\"https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions\">Bitbucket Data Center documentation</a> for a detailed explanation of what each permission entails.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource. In addition, a user may not reduce their own permission level unless they have a project or global permission that already implies that permission.", summary="Update user repository permission")
    @Parameters(value={@Parameter(description="The names of the users.", in=ParameterIn.QUERY, name="name", array=@ArraySchema(schema=@Schema(type="string")), required=true), @Parameter(description="The permission to grant", in=ParameterIn.QUERY, name="permission", schema=@Schema(allowableValues={"REPO_READ", "REPO_WRITE", "REPO_ADMIN"}), required=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested permission was granted.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's permission level.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPermissionForUser(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="name") Set<String> usernames, @QueryParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, Repository.class);
        Set<ApplicationUser> users = this.validateUsers(usernames);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repositoryResolver.getRepository()).users(users).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all permissions for the specified repository for a user.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource.\n\nIn addition, a user may not revoke their own repository permissions if they do not have a higher project or global permission.", summary="Revoke user repository permission")
    @Parameter(description="The name of the user.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="All repository permissions were revoked from the user for the specified repository.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's permission level.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissionsForUser(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="name") String username) {
        ApplicationUser user = this.validateUser(username, true);
        this.permissionAdminService.revokeAllRepositoryPermissions(repositoryResolver.getRepository(), user);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all permissions for the specified repository for a group.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project or global permission to call this resource.\n\nIn addition, a user may not revoke a group's permissions if it will reduce their own permission level.", summary="Revoke group repository permission")
    @Parameter(description="The name of the group.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="All repository permissions were revoked from the group for the specified repository.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not a repository administrator for the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's permission level.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissionsForGroup(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="name") String groupName) {
        groupName = this.validateGroup(groupName, true);
        this.permissionAdminService.revokeAllRepositoryPermissions(repositoryResolver.getRepository(), groupName);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all permissions for the specified repository for the given groups and users.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified repository or a higher global permission to call this resource.\n\nIn addition, a user may not revoke a group's permission if their own permission would be revoked as a result, nor may they revoke their own permission unless they have a global permission that already implies that permission.", summary="Revoke all repository permissions for users and groups")
    @Parameters(value={@Parameter(description="The names of the groups", in=ParameterIn.QUERY, name="group"), @Parameter(description="The names of the users", in=ParameterIn.QUERY, name="user")})
    @ResponseDocs(value={@ResponseDoc(documentation="All repository permissions were revoked from the users and groups for the specified repository.", responseCode=204), @ResponseDoc(documentation="No permissions were revoked because the request was invalid. No users or groups were provided.", responseCode=400), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specified repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist, or one or more of the users or groups provided does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The action was disallowed as it would revoke the currently authenticated user's permission on the repository.", restError=true, responseCode=409)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissions(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="group") Set<String> groupNames, @QueryParam(value="user") Set<String> usernames) {
        Set<String> groups = this.validateGroupsForRevocation(groupNames);
        Set<ApplicationUser> users = this.validateUsersForRevocation(usernames);
        if (groups.isEmpty() && users.isEmpty()) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.permission.no.principals", new Object[0]));
        }
        this.permissionAdminService.revokeAllRepositoryPermissions(repositoryResolver.getRepository(), groups, users);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Search direct and implied permissions of users and groups. This endpoint returns a superset of the results returned by the /users and /groups endpoints because it allows filtering by project and global permissions too.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository or a higher project/global permission to call this resource.", summary="Search repository permissions")
    @Parameters(value={@Parameter(description="Name of the user or group to filter the name of", in=ParameterIn.QUERY, name="filterText"), @Parameter(description="Type of entity (user or group)Valid entity types are:\n\n- USER- GROUP", in=ParameterIn.QUERY, name="type"), @Parameter(description="Permissions to filter by. See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions)for a detailed explanation of what each permission entails. This parameter can be specified multiple times to filter by more than one permission, and can contain repository, project, and global permissions.\n\n", in=ParameterIn.QUERY, name="permission")})
    @GET
    @Path(value="search")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchPermissions(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filterText") String filterText, @QueryParam(value="type") String type, @QueryParam(value="permission") Set<String> permissions, @BeanParam PageRequestResolver pageRequestResolver) {
        Page principals = this.permissionAdminService.searchPrincipals((PermittedPrincipalSearchRequest)new PermittedPrincipalRepositorySearchRequest(repositoryResolver.getRepository(), StringUtils.trimToNull((String)filterText), this.parseType(type), this.parsePermissions(permissions)), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(principals, RestPermittedPrincipal.REST_TRANSFORM)).build();
    }
}

