/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.InvalidNameException;
import com.atlassian.bitbucket.NoUniqueUserIdentifierException;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestDetailedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestErasedUser;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mail.NoMailHostConfigurationException;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.exception.ConflictException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestDetailedUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.DetailedGroup;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.IllegalUserStateException;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserErasureException;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.user.Validators;
import com.atlassian.stash.internal.rest.user.json.AdminPasswordUpdate;
import com.atlassian.stash.internal.rest.user.json.GroupAndUsers;
import com.atlassian.stash.internal.rest.user.json.GroupPickerContext;
import com.atlassian.stash.internal.rest.user.json.UserAndGroups;
import com.atlassian.stash.internal.rest.user.json.UserPickerContext;
import com.atlassian.stash.internal.rest.user.json.UserRename;
import com.atlassian.stash.internal.rest.user.json.UserUpdate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="admin")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Permission Management")
public class UserAdminResource {
    private static final Logger log = LoggerFactory.getLogger(UserAdminResource.class);
    private final I18nService i18nService;
    private final UserAdminService userAdminService;
    private final Validator validator;

    @Inject
    public UserAdminResource(I18nService i18nService, UserAdminService userAdminService, Validator validator) {
        this.i18nService = i18nService;
        this.userAdminService = userAdminService;
        this.validator = validator;
    }

    @Operation(description="Retrieve a page of users. \n\n The authenticated user must have the <strong>LICENSED_USER</strong> permission to call this resource.", summary="Get users")
    @Parameter(description="If specified only users with usernames, display name or email addresses containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users.", paged=true, representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a licensed user.", responseCode=401, restError=true)})
    @GET
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsers(@QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.userAdminService.findUsersByName(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Creates a new user from the assembled query parameters.\n\nThe default group can be used to control initial permissions for new users, such as granting users the ability to login or providing read access to certain projects or repositories. If the user is not added to the default group, they may not be able to login after their account is created until explicit permissions are configured.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Create user")
    @Parameters(value={@Parameter(description="The username for the new user.", in=ParameterIn.QUERY, name="name", required=true), @Parameter(description="The password for the new user. Required if the <code>notify</code> parameter is not present or is set to <code>false</false>", in=ParameterIn.QUERY, name="password"), @Parameter(description="The display name for the new user.", in=ParameterIn.QUERY, name="displayName", required=true), @Parameter(description="The e-mail address for the new user.", in=ParameterIn.QUERY, name="emailAddress", required=true), @Parameter(description="Set <code>true</code> to add the user to the default group, which can be used to grant them a set of initial permissions; otherwise, <code>false</code> to not add them to a group.", in=ParameterIn.QUERY, name="addToDefaultGroup", schema=@Schema(defaultValue="true", type="boolean")), @Parameter(description="If present and not <code>false</code> instead of requiring a password, the create user will be notified via email their account has been created and requires a password to be reset. This option can only be used if a mail server has been configured.", in=ParameterIn.QUERY, name="notify", schema=@Schema(type="boolean"))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user was successfully created.", responseCode=204), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user is not an administrator.", responseCode=401, restError=true), @ResponseDoc(documentation="Adding the user to the default group would exceed the server's license limit.", responseCode=403, restError=true), @ResponseDoc(documentation="Another user with the same name already exists.", responseCode=409, restError=true)})
    @POST
    @Path(value="users")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createUser(@QueryParam(value="name") String username, @QueryParam(value="password") String password, @QueryParam(value="displayName") String displayName, @QueryParam(value="emailAddress") String emailAddress, @QueryParam(value="addToDefaultGroup") @DefaultValue(value="true") boolean addToDefaultGroup, @QueryParam(value="notify") String notify) {
        boolean sendPasswordResetEmail;
        boolean bl = sendPasswordResetEmail = notify != null && !"false".equalsIgnoreCase(notify);
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.username", new Object[0]);
            throw new BadRequestException(message);
        }
        if (!sendPasswordResetEmail && StringUtils.isEmpty((CharSequence)password)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.password", new Object[0]);
            throw new BadRequestException(message);
        }
        if (StringUtils.isEmpty((CharSequence)displayName)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.displayname", new Object[0]);
            throw new BadRequestException(message);
        }
        if (StringUtils.isEmpty((CharSequence)emailAddress)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.email", new Object[0]);
            throw new BadRequestException(message);
        }
        if (!new EmailValidator().isValid((CharSequence)emailAddress, null)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.invalid.email", new Object[0]);
            throw new BadRequestException(message);
        }
        if (sendPasswordResetEmail) {
            try {
                this.userAdminService.createUserWithGeneratedPassword(username, displayName, emailAddress);
            }
            catch (NoMailHostConfigurationException e) {
                String message = this.i18nService.getMessage("bitbucket.service.user.create.no.mail.server", new Object[0]);
                throw new ConflictException(message);
            }
        } else {
            this.userAdminService.createUser(username, password, displayName, emailAddress, addToDefaultGroup);
        }
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Deletes the specified user, removing them from the system. This also removes any permissions that may have been granted to the user.\n\nA user may not delete themselves, and a user with <strong>ADMIN</strong> permissions may not delete a user with <strong>SYS_ADMIN</strong> permissions.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.\n\nNote: The permission removal process occurs 7 days after the user deletion.", summary="Remove user")
    @Parameter(description="The username identifying the user to delete.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The deleted user.", representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as the authenticated user has a lower permission level than the user being deleted.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as a user can not delete themselves.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="users")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteUser(@QueryParam(value="name") String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.delete.no.username", new Object[0]);
            throw new BadRequestException(message);
        }
        DetailedUser user = this.userAdminService.deleteUser(username);
        return ResponseFactory.ok(RestDetailedUser.REST_TRANSFORM.apply(user)).build();
    }

    @Operation(description="Validate if a user can be erased.\n\nA username is only valid for erasure if it exists as the username of a deleted user. This endpoint will return an appropriate error response if the supplied username is invalid for erasure.\n\nThis endpoint does <strong>not</strong> perform the actual user erasure, and will not modify the application in any way.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Check user removal")
    @Parameter(description="The username of the user to validate erasability for.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="the user is erasable", responseCode=204), @ResponseDoc(documentation="The request was malformed (e.g. if no username was supplied).", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission or has a lower permission level than the user being erased.", responseCode=401, restError=true), @ResponseDoc(documentation="The requested username does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The requested username is the username of a not deleted user.", responseCode=409, restError=true)})
    @GET
    @Path(value="users/erasure")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response validateErasable(@QueryParam(value="name") String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.erase.no.username", new Object[0]);
            throw new BadRequestException(message);
        }
        try {
            this.userAdminService.validateErasable(username);
            return ResponseFactory.noContent().build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.erase.notAuthorised", new Object[0]));
        }
        catch (IllegalUserStateException e) {
            return ResponseFactory.error((Response.Status)Response.Status.CONFLICT, (String)"username", (String)this.i18nService.getMessage("bitbucket.rest.user.erase.notDeleted", new Object[0])).build();
        }
    }

    @Operation(description="Erases personally identifying user data for a deleted user.\n\nReferences in the application to the original username will be either removed or updated to a new non-identifying username. Refer to the <a href=\"https://confluence.atlassian.com/gdpr/bitbucket-right-to-erasure-949770560.html\">support guide</a> for details about what data is and isn't erased.\n\nUser erasure can only be performed on a deleted user. If the user has not been deleted first then this endpoint will return a bad request and no erasure will be performed.\n\nErasing user data is <strong>irreversible</strong> and may lead to a degraded user experience. This method should not be used as part of a standard user deletion and cleanup process.\n\nPlugins can participate in user erasure by defining a <code>&lt;user-erasure-handler&gt;</code> module. If one or more plugin modules fail, an error summary of the failing modules is returned.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Erase user information")
    @Parameter(description="The username identifying the user to erase.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The identifier of the erased user.", representation=RestErasedUser.class, responseCode=200), @ResponseDoc(documentation="The request was malformed (e.g. if no username was supplied).", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission or has a lower permission level than the user being erased.", responseCode=401, restError=true), @ResponseDoc(documentation="The requested username does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The requested username is the username of a not deleted user.", responseCode=409, restError=true)})
    @POST
    @Path(value="users/erasure")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response eraseUser(@QueryParam(value="name") String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.erase.no.username", new Object[0]);
            throw new BadRequestException(message);
        }
        try {
            String newIdentifier = this.userAdminService.eraseUser(username);
            log.info("Erasure of user finished. New identifier: {}'", (Object)newIdentifier);
            return ResponseFactory.ok(RestErasedUser.REST_TRANSFORM.apply(newIdentifier)).build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.erase.notAuthorised", new Object[0]));
        }
        catch (IllegalUserStateException e) {
            return ResponseFactory.error((Response.Status)Response.Status.CONFLICT, (String)"username", (String)this.i18nService.getMessage("bitbucket.rest.user.erase.notDeleted", new Object[0])).build();
        }
        catch (NoUniqueUserIdentifierException e) {
            return ResponseFactory.errors((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (RestErrors)new RestErrors(this.i18nService.getMessage("bitbucket.rest.user.erase.noUniqueUserIdentifierGenerated", new Object[]{username}))).build();
        }
        catch (UserErasureException e) {
            return ResponseFactory.errors((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (RestErrors)new RestErrors.Builder().add(e.getKeyedMessage().getLocalisedMessage()).addErrorMessages((Iterable)e.getCauses().entrySet().stream().map(entry -> {
                Throwable t = (Throwable)entry.getValue();
                return new RestErrorMessage((String)entry.getKey(), t.getLocalizedMessage(), t.getClass().getCanonicalName());
            }).collect(MoreCollectors.toImmutableList())).build()).build();
        }
    }

    @Operation(description="Update a user's details. \n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Update user details")
    @RequestBody(content={@Content(schema=@Schema(implementation=UserUpdate.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated user.", representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission or has a lower permission level than the user being updated.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="users")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateUserDetails(UserUpdate update) {
        Validators.validateConstraints(this.validator, update);
        try {
            DetailedUser user = this.userAdminService.updateUser(update.getName(), update.getDisplayName(), update.getEmail());
            return ResponseFactory.ok(RestDetailedUser.REST_TRANSFORM.apply(user)).build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.update.notAuthorised", new Object[0]));
        }
    }

    @Operation(description="Rename a user. \n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Rename user")
    @RequestBody(content={@Content(schema=@Schema(implementation=UserRename.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The renamed user.", representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission or has a lower permission level than the user being renamed.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="users/rename")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response renameUser(UserRename rename) {
        Validators.validateConstraints(this.validator, rename);
        try {
            DetailedUser user = this.userAdminService.renameUser(rename.getName(), rename.getNewName());
            return ResponseFactory.ok(RestDetailedUser.REST_TRANSFORM.apply(user)).build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.rename.notAuthorised", new Object[0]));
        }
    }

    @Operation(description="Update a user's password. \n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource, and may not update the password of a user with greater permissions than themselves.", summary="Set password for user")
    @RequestBody(content={@Content(schema=@Schema(implementation=AdminPasswordUpdate.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user's password was successfully updated.", responseCode=204), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission or has a lower permission level than the user having their password updated.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="users/credentials")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateUserPassword(AdminPasswordUpdate update) {
        Validators.validateConstraints(this.validator, update);
        try {
            this.userAdminService.updatePassword(update.getName(), update.getPassword());
            return ResponseFactory.noContent().build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.update.notAuthorised", new Object[0]));
        }
    }

    @Operation(description="Clears any CAPTCHA challenge that may constrain the user with the supplied username when they authenticate. Additionally any counter or metric that contributed towards the user being issued the CAPTCHA challenge (for instance too many consecutive failed logins) will also be reset.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource, and may not clear the CAPTCHA of a user with greater permissions than themselves.", summary="Clear CAPTCHA for user")
    @Parameter(description="The username", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The CAPTCHA was successfully cleared.", responseCode=204), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as the authenticated user has a lower permission level than the user to clear captcha for.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="users/captcha")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response clearUserCaptchaChallenge(@QueryParam(value="name") String username) {
        if (StringUtils.isEmpty((CharSequence)username) || username.length() > 255) {
            throw new InvalidNameException(this.i18nService.createKeyedMessage("bitbucket.bad.user.name", new Object[0]));
        }
        try {
            this.userAdminService.clearCaptchaChallenge(username);
            return ResponseFactory.noContent().build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.update.notAuthorised", new Object[0]));
        }
    }

    @Operation(description="Retrieve a page of groups. \n\nThe authenticated user must have <strong>LICENSED_USER</strong> permission or higher to call this resource.", summary="Get groups")
    @Parameter(description="If specified only group names containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups.", paged=true, representation=RestDetailedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a licensed user.", responseCode=401, restError=true)})
    @GET
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroups(@QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.userAdminService.findGroupsByName(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedGroup.REST_TRANSFORM)).build();
    }

    @Operation(description="Create a new group. \n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Create group")
    @Parameter(description="Name of the group.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created group.", representation=RestDetailedGroup.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not an administrator.", responseCode=401, restError=true), @ResponseDoc(documentation="A group with this name already exists.", responseCode=409, restError=true)})
    @POST
    @Path(value="groups")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createGroup(@QueryParam(value="name") String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName) || groupName.length() > 255) {
            throw new InvalidNameException(this.i18nService.createKeyedMessage("bitbucket.bad.group.name", new Object[0]));
        }
        DetailedGroup group = this.userAdminService.createGroup(groupName);
        return ResponseFactory.ok(RestDetailedGroup.REST_TRANSFORM.apply(group)).build();
    }

    @Operation(description="Deletes the specified group, removing them from the system. This also removes any permissions that may have been granted to the group.\n\nA user may not delete the last group that is granting them administrative permissions, or a group with greater permissions than themselves.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Remove group")
    @Parameter(description="The name identifying the group to delete.", in=ParameterIn.QUERY, name="name", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The deleted group.", representation=RestDetailedGroup.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as the authenticated user has a lower permission level than the group being deleted.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified group does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would lower the authenticated user's permission level.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="groups")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteGroup(@QueryParam(value="name") String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.delete.no.groupname", new Object[0]);
            throw new BadRequestException(message);
        }
        DetailedGroup group = this.userAdminService.deleteGroup(groupName);
        return ResponseFactory.ok(RestDetailedGroup.REST_TRANSFORM.apply(group)).build();
    }

    @Operation(description="<strong>Deprecated since 2.10</strong>. Use /rest/users/add-groups instead.\n\nAdd a user to a group.\n\nIn the request entity, the <em>context</em> attribute is the group and the <em>itemName</em> is the user.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Add user to group", deprecated=true)
    @RequestBody(content={@Content(schema=@Schema(implementation=UserPickerContext.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user was added to the group.", responseCode=200), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would exceed the server's licensing limit, or the groups permissions exceed the authenticated user's permission level.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user or group does not exist.", responseCode=404, restError=true)})
    @Tag(name="Deprecated")
    @Deprecated
    @POST
    @Path(value="groups/add-user")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addUserToGroup(UserPickerContext data) {
        String groupName = data.getContext();
        String username = data.getItemName();
        return this.addUserToGroup(groupName, username);
    }

    @Operation(description="<strong>Deprecated since 2.10</strong>. Use /rest/users/add-groups instead.\n\nAdd a user to a group. This is very similar to <code>groups/add-user</code>, but with the <em>context</em> and <em>itemName</em> attributes of the supplied request entity reversed. On the face of it this may appear redundant, but it facilitates a specific UI component in the application.\n\nIn the request entity, the <em>context</em> attribute is the user and the <em>itemName</em> is the group.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Add user to group", deprecated=true)
    @RequestBody(content={@Content(schema=@Schema(implementation=GroupPickerContext.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user was added to the group", responseCode=200), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would exceed the server's licensing limit, or the groups permissions exceed the authenticated user's permission level.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user or group does not exist.", responseCode=404, restError=true)})
    @Tag(name="Deprecated")
    @Deprecated
    @POST
    @Path(value="users/add-group")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addGroupToUser(GroupPickerContext data) {
        String groupName = data.getItemName();
        String userName = data.getContext();
        return this.addUserToGroup(groupName, userName);
    }

    @Operation(description="Add multiple users to a group. \n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Add multiple users to group")
    @RequestBody(content={@Content(schema=@Schema(implementation=GroupAndUsers.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="<em>All</em> the users were added to the group", responseCode=200), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would exceed the server's licensing limit, or the groups permissions exceed the authenticated user's permission level.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user or group does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="groups/add-users")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addUsersToGroup(GroupAndUsers data) {
        this.userAdminService.addMembersToGroup(data.getGroup(), data.getUsers());
        return ResponseFactory.ok().build();
    }

    @Operation(description="Add a user to one or more groups. \n\n The authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Add user to groups")
    @RequestBody(content={@Content(schema=@Schema(implementation=UserAndGroups.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user was added to <em>all</em> the groups", responseCode=200), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would exceed the server's licensing limit, or the groups permissions exceed the authenticated user's permission level.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user or group does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="users/add-groups")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addUserToGroups(UserAndGroups data) {
        this.userAdminService.addUserToGroups(data.getUser(), data.getGroups());
        return ResponseFactory.ok().build();
    }

    @Operation(description="<strong>Deprecated since 2.10</strong>. Use /rest/users/remove-groups instead.\n\nRemove a user from a group.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.\n\nIn the request entity, the <em>context</em> attribute is the group and the <em>itemName</em> is the user.", summary="Remove user from group", deprecated=true)
    @RequestBody(content={@Content(schema=@Schema(implementation=UserPickerContext.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user was removed from the group.", responseCode=200), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as the group has a higher permission level than the context user.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user or group does not exist.", responseCode=404, restError=true)})
    @Tag(name="Deprecated")
    @Deprecated
    @POST
    @Path(value="groups/remove-user")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response removeUserFromGroup(UserPickerContext data) {
        String groupName = data.getContext();
        String username = data.getItemName();
        return this.removeUserFromGroup(groupName, username);
    }

    @Operation(description="Remove a user from a group. This is very similar to <code>groups/remove-user</code>, but with the <em>context</em> and <em>itemName</em> attributes of the supplied request entity reversed. On the face of it this may appear redundant, but it facilitates a specific UI component in the application.\n\nIn the request entity, the <em>context</em> attribute is the user and the <em>itemName</em> is the group.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Remove user from group")
    @RequestBody(content={@Content(schema=@Schema(implementation=GroupPickerContext.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user was removed from the group.", responseCode=200), @ResponseDoc(documentation="The authenticated user does not have the <strong>ADMIN</strong> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as the group has a higher permission level than the context user.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user or group does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="users/remove-group")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response removeGroupFromUser(GroupPickerContext data) {
        String groupName = data.getItemName();
        String username = data.getContext();
        return this.removeUserFromGroup(groupName, username);
    }

    @Operation(description="Retrieves a list of users that are members of a specified group. <p>The authenticated user must have the <strong>LICENSED_USER</strong> permission to call this resource.", summary="Get group members")
    @Parameters(value={@Parameter(description="The group which should be used to locate members.", in=ParameterIn.QUERY, name="context", required=true), @Parameter(description="If specified only users with usernames, display names or email addresses containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users.", paged=true, representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a licensed user.", responseCode=401, restError=true)})
    @GET
    @Path(value="groups/more-members")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findUsersInGroup(@QueryParam(value="context") String groupName, @QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        this.checkContext(groupName);
        Page page = this.userAdminService.findUsersWithGroup(groupName, filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves a list of users that are <em>not</em> members of a specified group. <p>The authenticated user must have the <strong>LICENSED_USER</strong> permission to call this resource.", summary="Get members not in group")
    @Parameters(value={@Parameter(description="The group which should be used to locate members.", in=ParameterIn.QUERY, name="context", required=true), @Parameter(description="If specified only users with usernames, display names or email addresses containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users.", paged=true, representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a licensed user.", responseCode=401, restError=true)})
    @GET
    @Path(value="groups/more-non-members")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findUsersNotInGroup(@QueryParam(value="context") String groupName, @QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        this.checkContext(groupName);
        Page page = this.userAdminService.findUsersWithoutGroup(groupName, filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves a list of users that are <em>not</em> members of a specified group. <p>The authenticated user must have the <strong>LICENSED_USER</strong> permission to call this resource.", summary="Get groups for user")
    @Parameters(value={@Parameter(description="The group which should be used to locate members.", in=ParameterIn.QUERY, name="context", required=true), @Parameter(description="If specified only users with usernames, display names or email addresses containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users.", paged=true, representation=RestDetailedUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a licensed user.", responseCode=401, restError=true)})
    @GET
    @Path(value="users/more-members")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findGroupsForUser(@QueryParam(value="context") String username, @QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        this.checkContext(username);
        Page page = this.userAdminService.findGroupsWithUser(username, filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedGroup.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves a list of groups the specified user is <em>not</em> a member of. <p>The authenticated user must have the <strong>LICENSED_USER</strong> permission to call this resource.", summary="Find other groups for user")
    @Parameters(value={@Parameter(description="The user which should be used to locate groups.", in=ParameterIn.QUERY, name="context", required=true), @Parameter(description="If specified only groups with names containing the supplied string will be returned.", in=ParameterIn.QUERY, name="filter")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups.", paged=true, representation=RestDetailedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a licensed user.", responseCode=401, restError=true)})
    @GET
    @Path(value="users/more-non-members")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findOtherGroupsForUser(@QueryParam(value="context") String username, @QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        this.checkContext(username);
        Page page = this.userAdminService.findGroupsWithoutUser(username, filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedGroup.REST_TRANSFORM)).build();
    }

    private Response addUserToGroup(String groupName, String username) {
        this.userAdminService.addUserToGroups(username, Collections.singleton(groupName));
        return ResponseFactory.ok().build();
    }

    private void checkContext(String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.members.no.context", new Object[0]);
            throw new BadRequestException(message);
        }
    }

    private Response removeUserFromGroup(String groupName, String userName) {
        this.userAdminService.removeUserFromGroup(groupName, userName);
        return ResponseFactory.ok().build();
    }
}

