/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestUserDirectory;
import com.atlassian.bitbucket.dmz.user.DmzUserAdminService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/user-directories")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Permission Management")
@WebSudoRequired
public class UserDirectoryResource {
    private final DmzUserAdminService userAdminService;

    @Inject
    public UserDirectoryResource(DmzUserAdminService userAdminService) {
        this.userAdminService = userAdminService;
    }

    @Operation(description="Retrieve a list of active directories. \n\n The authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Get directories")
    @Parameter(description="Set <code>true</code> to include inactive directories; otherwise, <code>false</code> to only return active directories.", in=ParameterIn.QUERY, name="includeInactive")
    @ResponseDocs(value={@ResponseDoc(documentation="A list of directories", representation=RestUserDirectory.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not an administrator", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUserDirectories(@QueryParam(value="includeInactive") @DefaultValue(value="false") boolean includeInactive) {
        return Response.ok(this.userAdminService.listDirectories(includeInactive).stream().map(RestUserDirectory::new).collect(Collectors.toList())).build();
    }
}

