/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.UserResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestNamedLink;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.avatar.AvatarMultipartConfig;
import com.atlassian.stash.internal.rest.avatar.FilePartAvatarSupplier;
import com.atlassian.stash.internal.rest.user.RestUserSearchRequestParser;
import com.atlassian.stash.internal.rest.user.Validators;
import com.atlassian.stash.internal.rest.user.json.UserPasswordUpdate;
import com.atlassian.stash.internal.rest.user.json.UserUpdateWithCredentials;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

@Tag(name="System Maintenance")
@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="users")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UserResource {
    private static final String AVATAR_PATH = "{userSlug}/avatar.png";
    private final AvatarService avatarService;
    private final RestUserSearchRequestParser userSearchRequestParser;
    private final UserService userService;
    private final Validator validator;

    @Inject
    public UserResource(AvatarService avatarService, UserService userService, RestUserSearchRequestParser userSearchRequestParser, Validator validator) {
        this.avatarService = avatarService;
        this.userSearchRequestParser = userSearchRequestParser;
        this.userService = userService;
        this.validator = validator;
    }

    @Operation(description="Delete the avatar associated to a user.\n\n\nUsers are always allowed to delete their own avatar. To delete someone else's avatar the authenticated user must\nhave global <strong>ADMIN</strong> permission, or global <strong>SYS_ADMIN</strong> permission to update a\n<strong>SYS_ADMIN</strong> user's avatar.", summary="Delete user avatar")
    @Parameter(name="userSlug", in=ParameterIn.PATH, description="The user slug")
    @ResponseDocs(value={@ResponseDoc(documentation="The new avatar URL if the local avatar was successfully deleted or did not exist", representation=RestNamedLink.class, responseCode=200), @ResponseDoc(documentation="The authenticated user has insufficient permissions to delete the specified avatar.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{userSlug}/avatar.png")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteAvatar(@BeanParam UserResolver userResolver, @Context ContainerRequestContext requestContext) {
        this.userService.deleteAvatar(userResolver.getUser());
        String avatarUrl = this.avatarService.getUrlForPerson((Person)userResolver.getUser(), new AvatarRequest(requestContext.getSecurityContext().isSecure(), 256, true));
        return ResponseFactory.ok((Object)new RestNamedLink(avatarUrl)).build();
    }

    @Operation(description="Retrieve the user matching the supplied <strong>userSlug</strong>.", summary="Get user")
    @Parameter(name="userSlug", in=ParameterIn.PATH, description="The user slug")
    @ResponseDocs(value={@ResponseDoc(documentation="The user matching the supplied <strong>userSlug</strong>. Note, this may\n<i>not</i> be the user's username, always use the <strong>user.slug</strong> property.", representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the user.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{userSlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUser(@BeanParam UserResolver userResolver) {
        Response.ResponseBuilder responseBuilder = ResponseFactory.ok(RestApplicationUser.REST_TRANSFORM.apply(userResolver.getUser()));
        if (userResolver.getUser() instanceof ServiceUser) {
            responseBuilder.cacheControl(CachePolicies.cacheForAMonth());
        }
        return responseBuilder.build();
    }

    @Operation(description="Retrieve a page of users, optionally run through provided filters.\n\n\nOnly authenticated users may call this resource.\n### Permission Filters\n\n\nThe following three sub-sections list parameters supported for permission filters (where <code>[root]</code> is\nthe root permission filter name, e.g. <code>permission</code>, <code>permission.1</code> etc.) depending on the\npermission resource. The system determines which filter to apply (Global, Project or Repository permission)\nbased on the `[root]` permission value. E.g. <code>ADMIN</code> is a global permission,\n<code>PROJECT_ADMIN</code> is a project permission and <code>REPO_ADMIN</code> is a repository permission. Note\nthat the parameters for a given resource will be looked up in the order as they are listed below, that is e.g.\nfor a project resource, if both <code>projectId</code> and <code>projectKey</code> are provided, the system will\nuse <code>projectId</code> for the lookup.\n<h4>Global permissions</h4>\n\n\nThe permission value under <code>[root]</code> is the only required and recognized parameter, as global\npermissions do not apply to a specific resource.\n\n\nExample valid filter: <code>permission=ADMIN</code>.\n<h4>Project permissions</h4>\n\n\n- <code>[root]</code>- specifies the project permission\n- <code>[root].projectId</code> - specifies the project ID to lookup the project by\n- <code>[root].projectKey</code> - specifies the project key to lookup the project by\n\n\nExample valid filter: <code>permission.1=PROJECT_ADMIN&amp;permission.1.projectKey=TEST_PROJECT</code>.\n#### Repository permissions\n\n\n- <code>[root]</code>- specifies the repository permission\n- <code>[root].projectId</code> - specifies the repository ID to lookup the repository by\n- <code>[root].projectKey</code> and <code>[root].repositorySlug</code>- specifies the project key and     repository slug to lookup the repository by; both values <i>need to</i> be provided for this look up to be     triggered\n\n\nExample valid filter: <code>permission.2=REPO_ADMIN&amp;permission.2.projectKey=TEST_PROJECT&amp;permission.2.repositorySlug=test_repo</code>.", summary="Get all users")
    @Parameters(value={@Parameter(name="filter", description="Return only users, whose username, name or email address <i>contain</i> the <code> filter</code> value", in=ParameterIn.QUERY), @Parameter(name="group", description="return only users who are members of the given group", in=ParameterIn.QUERY), @Parameter(name="permission", description="The \"root\" of a permission filter, whose value must be a valid global, project, or repository permission. Additional filter parameters referring to this filter that specify the resource (project or repository) to apply the filter to must be prefixed with <code>permission.</code>. See the section \"Permission Filters\" above for more details.", in=ParameterIn.QUERY), @Parameter(name="permission.N", description="The \"root\" of a single permission filter, similar to the <code>permission</code> parameter, where \"N\" is a natural number starting from 1. This allows clients to specify multiple permission filters, by providing consecutive filters as <code>permission.1</code>, <code>permission.2</code> etc. Note that the filters numbering has to start with 1 and be continuous for all filters to be processed. The total allowed number of permission filters is 50 and all filters exceeding that limit will be dropped. See the section \"Permission Filters\" above for more details on how the permission filters are processed.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users.", representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The search request was invalid, which may happen for multiple reasons, among\nothers:\n\n\n- permission filter for project/repository permission with no parameters specifying the project or     repository to apply the filter to\n- invalid permission name\n- permission filter for a project/repository permission pointing to a non-existent project or repository\n\n\nThe exact reason for the error and - in most cases - the request parameter name that had invalid value - will be\nprovided in the error message.", responseCode=400, restError=true), @ResponseDoc(documentation="Authentication failed or was not attempted.", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsers(@Context UriInfo uriInfo, @BeanParam PageRequestResolver pageRequestResolver) {
        UserSearchRequest searchRequest = this.userSearchRequestParser.parse((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        Page users = this.userService.search(searchRequest, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(users, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Update the avatar for the user with the supplied <strong>slug</strong>.\n\n\nThis resource accepts POST multipart form data, containing a single image in a form-field named 'avatar'.\n\n\nThere are configurable server limits on both the dimensions (1024x1024 pixels by default) and uploaded\nfile size (1MB by default). Several different image formats are supported, but <strong>PNG</strong> and\n<strong>JPEG</strong> are preferred due to the file size limit.\n\n\nThis resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to\npass the XSRF check the caller needs to send an <code>X-Atlassian-Token</code> HTTP header with the\nvalue <code>no-check</code>.\n\n\nAn example <a href=\"http://curl.haxx.se/\">curl</a> request to upload an image name 'avatar.png' would be:\n```\ncurl -X POST -u username:password -H \"X-Atlassian-Token: no-check\" http://example.com/rest/api/latest/users/jdoe/avatar.png -F avatar=@avatar.png\n```\n\n\nUsers are always allowed to update their own avatar. To update someone else's avatar the authenticated user must\nhave global <strong>ADMIN</strong> permission, or global <strong>SYS_ADMIN</strong> permission to update a\n<strong>SYS_ADMIN</strong> user's avatar.", summary="Update user avatar")
    @ApiResponse(responseCode="201", description="The avatar was uploaded successfully.", headers={@Header(name="Location", description="The Location response header which indicates the URL of the avatar.", schema=@Schema(type="string"))})
    @Parameters(value={@Parameter(name="userSlug", in=ParameterIn.PATH, description="The user slug"), @Parameter(name="X-Atlassian-Token", in=ParameterIn.HEADER, description="This resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to pass the XSRF check the caller needs to send an <code>X-Atlassian-Token</code> HTTP header with the value <code>no-check</code>.", example="no-check")})
    @RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExampleAvatarMultipartFormData.class))}, description="Multipart form data containing a single image in a form-field named 'avatar'.")
    @ResponseDocs(value={@ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the avatar.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=AvatarMultipartConfig.class)
    @Path(value="{userSlug}/avatar.png")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response uploadAvatar(@BeanParam UserResolver userResolver, @Context UriInfo uriInfo, @MultipartFormParam(value="avatar") FilePart file) {
        this.userService.updateAvatar(userResolver.getUser(), (AvatarSupplier)new FilePartAvatarSupplier(file));
        return Response.created((URI)uriInfo.getRequestUri()).build();
    }

    @Operation(description="Update the currently authenticated user's details. The update will always be applied to the currently authenticated user.", summary="Update user details")
    @RequestBody(description="The user update details", content={@Content(schema=@Schema(implementation=UserUpdateWithCredentials.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated user.", representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="Authentication failed or was not attempted.", responseCode=401, restError=true)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateUserDetails(UserUpdateWithCredentials u) {
        UserUpdateWithCredentials update = this.trimFields(u);
        Validators.validateConstraints(this.validator, update);
        ApplicationUser user = this.userService.updateUser(update.getDisplayName(), update.getEmail(), update.getPassword());
        return ResponseFactory.ok((Object)new RestApplicationUser(user)).build();
    }

    @Operation(description="Update the currently authenticated user's password.", summary="Set password")
    @RequestBody(description="The password update details", content={@Content(schema=@Schema(implementation=UserPasswordUpdate.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user's password was successfully updated.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the old password was incorrect.", responseCode=400, restError=true), @ResponseDoc(documentation="Authentication failed or was not attempted.", responseCode=401, restError=true)})
    @PUT
    @Path(value="credentials")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateUserPassword(UserPasswordUpdate update) {
        Validators.validateConstraints(this.validator, update);
        try {
            this.userService.updatePassword(update.getOldPassword(), update.getPassword());
            return ResponseFactory.noContent().build();
        }
        catch (IncorrectPasswordAuthenticationException e) {
            return Validators.reportAsConstraintViolation(update, "oldPassword", e.getLocalizedMessage());
        }
    }

    private UserUpdateWithCredentials trimFields(UserUpdateWithCredentials update) {
        return new UserUpdateWithCredentials(StringUtils.trimToNull((String)update.getName()), StringUtils.trimToNull((String)update.getDisplayName()), StringUtils.trimToNull((String)update.getEmail()), update.getPassword());
    }

    private static class ExampleAvatarMultipartFormData {
        private ExampleAvatarMultipartFormData() {
        }

        @Schema(description="The avatar file to upload.")
        public File getAvatar() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

