/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.UserResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.function.Function;

@PathParamDoc(name="userSlug", documentation="The user slug.")
@Tag(name="System Maintenance")
@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="users/{userSlug}/settings")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UserSettingsResource {
    private static final Function<UserSettings, Map<String, Object>> TO_MAP = new Function<UserSettings, Map<String, Object>>(){

        @Override
        public Map<String, Object> apply(UserSettings input) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String key : input.getKeys()) {
                builder.put((Object)key, this.getValueAsObject(input, key));
            }
            return builder.build();
        }

        private Object getValueAsObject(UserSettings userSettings, String key) {
            Option longSetting = userSettings.getLong(key);
            if (longSetting.isDefined()) {
                return longSetting.get();
            }
            Option stringSetting = userSettings.getString(key);
            if (stringSetting.isDefined()) {
                return stringSetting.get();
            }
            return userSettings.getBoolean(key).get();
        }
    };
    private final AuthenticationContext authenticationContext;
    private final UserSettingsService userSettingsService;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final WebSudoManager webSudoManager;

    @Inject
    public UserSettingsResource(AuthenticationContext authenticationContext, UserSettingsService userSettingsService, I18nService i18nService, PermissionService permissionService, WebSudoManager webSudoManager) {
        this.authenticationContext = authenticationContext;
        this.userSettingsService = userSettingsService;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.webSudoManager = webSudoManager;
    }

    @Operation(description="Retrieve a map of user setting key values for a specific user identified by the user slug.", summary="Get user settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The user settings for the specified user slug.", responseCode=200, representation=ExampleSettingsMap.class), @ResponseDoc(documentation="The currently authenticated user does not have permission to view the settings of this user.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit, or report does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUserSettings(@BeanParam UserResolver userResolver, @Context HttpServletRequest request) {
        ApplicationUser user = userResolver.getUser();
        this.checkPermission(user, request);
        UserSettings userSettings = this.userSettingsService.getUserSettings(UserKey.fromLong((long)user.getId()));
        return ResponseFactory.ok(TO_MAP.apply(userSettings)).build();
    }

    @Operation(description="Update the entries of a map of user setting key/values for a specific user identified by the user slug.", summary="Update user settings")
    @RequestBody(description="A map with the UserSettings entries which must be updated.", content={@Content(schema=@Schema(implementation=ExampleSettingsMap.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The UserSettings were updated successfully", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not a project administrator.", responseCode=401, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateSettings(@BeanParam UserResolver userResolver, @Context HttpServletRequest request, Map<String, Object> settingsMap) {
        ApplicationUser user = userResolver.getUser();
        this.checkPermission(user, request);
        this.userSettingsService.updateUserSettings(UserKey.fromLong((long)user.getId()), builder -> {
            for (Map.Entry entries : settingsMap.entrySet()) {
                Object value = entries.getValue();
                if (value instanceof String) {
                    builder.put((String)entries.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Integer || value instanceof Long) {
                    builder.put((String)entries.getKey(), ((Number)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    builder.put((String)entries.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.usersettings.bad.type", new Object[]{value}));
            }
            return builder.build();
        });
        return ResponseFactory.noContent().build();
    }

    private void checkPermission(ApplicationUser user, HttpServletRequest request) {
        if (!this.permissionService.hasUserPermission(user, Permission.USER_ADMIN)) {
            KeyedMessage keyedMessage = this.i18nService.createKeyedMessage("bitbucket.rest.user.settings.unauthorized", new Object[]{user.getDisplayName()});
            throw new AuthorisationException(keyedMessage);
        }
        if (!user.equals((Object)this.authenticationContext.getCurrentUser())) {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
    }

    private static class ExampleSettingsMap {
        private ExampleSettingsMap() {
        }

        @Schema(example="string value", name="string key")
        public String getStringKey() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="true", name="boolean key", type="boolean")
        public boolean getBooleanKey() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="10", name="long key", type="number")
        public long getLongKey() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

