/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.stash.internal.rest.user.ConstraintViolationComparator;
import com.google.common.base.Throwables;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public final class Validators {
    public static void validateConstraints(Validator validator, Object object) {
        ArrayList validationErrors = new ArrayList(validator.validate(object, new Class[0]));
        Collections.sort(validationErrors, new ConstraintViolationComparator());
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(new LinkedHashSet(validationErrors));
        }
    }

    public static Response reportAsConstraintViolation(Object object, String field, String message) {
        RestErrorMessage error = new RestErrorMessage(Validators.getField(object, field), message);
        RestErrors errors = new RestErrors(error);
        return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).type("application/json;charset=UTF-8").build();
    }

    private static String getField(Object object, String field) {
        try {
            return object.getClass().getDeclaredField(field).getName();
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

