/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.util;

import com.atlassian.stash.internal.rest.util.ByteLimitExceededException;
import java.io.ByteArrayOutputStream;

public class BoundedByteArrayOutputStream
extends ByteArrayOutputStream {
    private final int maxSize;

    public BoundedByteArrayOutputStream(int initialSize, int maxSize) {
        super(initialSize);
        this.maxSize = maxSize;
    }

    @Override
    public synchronized void write(int b) throws ByteLimitExceededException {
        this.validate(1);
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws ByteLimitExceededException {
        int lengthToWrite = this.truncateLength(len);
        super.write(b, off, lengthToWrite);
        this.validate(len - lengthToWrite);
    }

    private int truncateLength(int length) {
        return this.count + length > this.maxSize ? this.maxSize - this.count : length;
    }

    private void validate(int length) {
        int newLength = this.count + length;
        if (newLength > this.maxSize) {
            throw new ByteLimitExceededException(String.format("Maximum size %s of stream exceeded", this.maxSize));
        }
    }
}

