/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.util;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.dmz.comment.AddMultilineCommentRequest;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.comment.RestMultilineCommentMarker;
import com.atlassian.bitbucket.rest.v2.api.comment.RestMultilineCommentSpan;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class CommentUtils {
    private CommentUtils() {
    }

    @Nonnull
    public static AddMultilineCommentRequest createMultilineCommentRequest(@Nullable String fromHash, @Nullable String toHash, @Nonnull RestComment comment, @Nonnull CommentThreadDiffAnchorType diffType, @Nullable CommentSeverity severity, @Nonnull Commentable commentable, @Nonnull RestCommentThreadDiffAnchor anchor) {
        Objects.requireNonNull(comment, "comment");
        Objects.requireNonNull(diffType, "diffType");
        Objects.requireNonNull(commentable, "commentable");
        Objects.requireNonNull(anchor, "anchor");
        RestMultilineCommentSpan multilineSpan = anchor.getMultilineSpan();
        RestMultilineCommentMarker multilineMarker = anchor.getMultilineMarker();
        AddMultilineCommentRequest.Builder builder = (AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)((AddMultilineCommentRequest.Builder)new AddMultilineCommentRequest.Builder(commentable, comment.getText(), diffType, anchor.getPath().toString(), multilineMarker.getStartLine(), multilineMarker.getStartLineType()).fileType((DiffFileType)MoreObjects.firstNonNull((Object)anchor.getFileType(), (Object)DiffFileType.forSegmentType((DiffSegmentType)anchor.getLineType())))).fromHash(fromHash)).line(anchor.getLine())).lineType(anchor.getLineType())).pending(comment.isPending())).severity(severity)).srcPath((String)Optional.ofNullable(anchor.getSrcPath()).map(Object::toString).orElse(null))).toHash(toHash);
        if (multilineSpan.getSrcSpanStart().isPresent()) {
            builder.sourceSpan(new LineNumberRange(multilineSpan.getSrcSpanStart().getAsInt(), multilineSpan.getSrcSpanEnd().getAsInt()));
        }
        if (multilineSpan.getDstSpanStart().isPresent()) {
            builder.destinationSpan(new LineNumberRange(multilineSpan.getDstSpanStart().getAsInt(), multilineSpan.getDstSpanEnd().getAsInt()));
        }
        return builder.build();
    }
}

