/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.util;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.comment.RestMultilineCommentMarker;
import com.atlassian.bitbucket.rest.v2.api.comment.RestMultilineCommentSpan;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.ValidationUtils;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class MultilineCommentValidator {
    private static final int DEFAULT_MAX_SPAN_LENGTH = 100;
    private static final String MAX_SPAN_LENGTH_PROPERTY_KEY = "plugin.multiline.comment.max.span.size";
    private final I18nService i18nService;
    private final int maxSpanLength;
    private final Validator validator;

    public MultilineCommentValidator(ApplicationPropertiesService propertiesService, I18nService i18nService, Validator validator) {
        this.i18nService = i18nService;
        this.validator = validator;
        this.maxSpanLength = propertiesService.getPluginProperty(MAX_SPAN_LENGTH_PROPERTY_KEY, 100);
    }

    @Nonnull
    public List<RestErrorMessage> validateMultilineAnchor(RestCommentThreadDiffAnchor anchor) {
        if (anchor.getMultilineMarker() == null) {
            return List.of(new RestErrorMessage("multilineMarker", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.missingmarker", new Object[0])));
        }
        if (anchor.getMultilineSpan() == null) {
            return List.of(new RestErrorMessage("multilineSpan", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.missingspan", new Object[0])));
        }
        RestMultilineCommentMarker multilineCommentMarker = anchor.getMultilineMarker();
        RestMultilineCommentSpan multilineCommentSpan = anchor.getMultilineSpan();
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        this.validateMultilineMarker(multilineCommentMarker, anchor, errors);
        this.validateMultilineSpan(multilineCommentSpan, multilineCommentMarker, anchor, errors);
        return errors;
    }

    private void validateMultilineMarker(RestMultilineCommentMarker marker, RestCommentThreadDiffAnchor anchor, List<RestErrorMessage> errors) {
        ValidationUtils.validate((Validator)this.validator, (Object)marker, (Class[])new Class[0]);
        if (marker.getStartLine() == anchor.getLine() && marker.getStartLineType() == anchor.getLineType()) {
            errors.add(new RestErrorMessage("startLine", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.startendlinessame", new Object[0])));
        }
    }

    private void validateMultilineSpan(RestMultilineCommentSpan span, RestMultilineCommentMarker marker, RestCommentThreadDiffAnchor anchor, List<RestErrorMessage> errors) {
        ValidationUtils.validate((Validator)this.validator, (Object)span, (Class[])new Class[0]);
        OptionalInt srcSpanStart = span.getSrcSpanStart();
        OptionalInt srcSpanEnd = span.getSrcSpanEnd();
        OptionalInt dstSpanStart = span.getDstSpanStart();
        OptionalInt dstSpanEnd = span.getDstSpanEnd();
        if (srcSpanStart.isEmpty() && srcSpanEnd.isEmpty() && dstSpanStart.isEmpty() && dstSpanEnd.isEmpty()) {
            errors.add(new RestErrorMessage("multilineSpan", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.incompletespan", new Object[0])));
            return;
        }
        if (srcSpanStart.isPresent() != srcSpanEnd.isPresent()) {
            errors.add(new RestErrorMessage("multilineSpan", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.missingsrcspanvalue", new Object[0])));
        }
        if (dstSpanStart.isPresent() != dstSpanEnd.isPresent()) {
            errors.add(new RestErrorMessage("multilineSpan", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.missingdstspanvalue", new Object[0])));
        }
        if (srcSpanStart.isPresent() && srcSpanEnd.isPresent()) {
            if (dstSpanStart.isEmpty() && dstSpanEnd.isEmpty() && srcSpanStart.getAsInt() == srcSpanEnd.getAsInt()) {
                errors.add(new RestErrorMessage("multilineSpan", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.singlelinesrcspan", new Object[0])));
            }
            this.validateSpanRange(srcSpanStart.getAsInt(), srcSpanEnd.getAsInt(), "multilineSpan.srcSpanEnd", errors);
        }
        if (dstSpanStart.isPresent() && dstSpanEnd.isPresent()) {
            if (srcSpanStart.isEmpty() && srcSpanEnd.isEmpty() && dstSpanStart.getAsInt() == dstSpanEnd.getAsInt()) {
                errors.add(new RestErrorMessage("multilineSpan", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.singlelinedstspan", new Object[0])));
            }
            this.validateSpanRange(dstSpanStart.getAsInt(), dstSpanEnd.getAsInt(), "multilineSpan.dstSpanEnd", errors);
        }
        if (IntStream.concat(srcSpanStart.stream(), dstSpanStart.stream()).noneMatch(start -> start == marker.getStartLine())) {
            errors.add(new RestErrorMessage("multilineMarker.startLine", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.nospanmatchstartline", new Object[0])));
        }
        if (IntStream.concat(srcSpanEnd.stream(), dstSpanEnd.stream()).noneMatch(end -> end == anchor.getLine())) {
            errors.add(new RestErrorMessage("line", this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.nospanmatchendline", new Object[0])));
        }
    }

    private void validateSpanRange(int spanStart, int spanEnd, String context, List<RestErrorMessage> errors) {
        if (spanEnd < spanStart) {
            errors.add(new RestErrorMessage(context, this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.invalidrange", new Object[0])));
        }
        if (spanEnd - spanStart + 1 > this.maxSpanLength) {
            errors.add(new RestErrorMessage(context, this.i18nService.getMessage("bitbucket.rest.comment.anchor.multiline.invalidrange.length", new Object[]{this.maxSpanLength})));
        }
    }
}

