/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.util;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeConfig;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeStrategy;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nullable;
import java.util.Set;

public class RestMergeConfigUtils {
    private RestMergeConfigUtils() {
        throw new UnsupportedOperationException(RestMergeConfigUtils.class.getName() + " should not be instantiated");
    }

    public static Set<String> getMergeStrategyIds(Set<RestPullRequestMergeStrategy> strategies) {
        return (Set)strategies.stream().map(RestPullRequestMergeStrategy::getId).collect(MoreCollectors.toImmutableSet());
    }

    public static RestPullRequestCommitMessageTemplate verifyCommitMessageTemplate(@Nullable RestPullRequestMergeConfig config, I18nService i18nService) {
        RestPullRequestCommitMessageTemplate template;
        RestPullRequestCommitMessageTemplate restPullRequestCommitMessageTemplate = template = config == null ? null : config.getCommitMessageTemplate();
        if (template != null && !template.isEmpty()) {
            if (template.getTitle().isEmpty() && !template.getBody().isEmpty()) {
                throw new BadRequestException(i18nService.getMessage("bitbucket.service.pullrequest.mergeconfig.invalid.commitmessagetemplate.titlemissing", new Object[0]));
            }
            if (template.getTitle().length() > 255) {
                throw new BadRequestException(i18nService.getMessage("bitbucket.service.pullrequest.mergeconfig.invalid.commitmessagetemplate.titletoolong", new Object[]{255}));
            }
            if (template.getBody().length() > 5000) {
                throw new BadRequestException(i18nService.getMessage("bitbucket.service.pullrequest.mergeconfig.invalid.commitmessagetemplate.bodytoolong", new Object[]{5000}));
            }
        }
        return template;
    }

    public static RestPullRequestMergeStrategy verifyDefaultStrategy(@Nullable RestPullRequestMergeConfig config, I18nService i18nService) {
        RestPullRequestMergeStrategy defaultStrategy;
        RestPullRequestMergeStrategy restPullRequestMergeStrategy = defaultStrategy = config == null ? null : config.getDefaultStrategy();
        if (defaultStrategy == null || defaultStrategy.getId() == null || !defaultStrategy.isEnabled()) {
            throw new BadRequestException(i18nService.getMessage("bitbucket.service.pullrequest.mergeconfig.invalid.default", new Object[0]));
        }
        return defaultStrategy;
    }
}

