/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.webhook;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.webhook.WebhookScopeAdapter;
import com.atlassian.webhooks.WebhookScope;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RestWebhooksResourceHelper {
    private static final Set<String> SUPPORTED_SCOPE_TYPES = ImmutableSet.of((Object)ScopeType.PROJECT.name().toLowerCase(), (Object)ScopeType.REPOSITORY.name().toLowerCase());
    private static final Set<String> SUPPORTED_URL_VARIABLES_PROJECT_SCOPE = ImmutableSet.builder().add((Object)"project.key").build();
    private static final Set<String> SUPPORTED_URL_VARIABLES_REPOSITORY_PUSH_EVENT = ImmutableSet.builder().add((Object)"repo.slug").add((Object)"repo.ref.branchName").addAll(SUPPORTED_URL_VARIABLES_PROJECT_SCOPE).build();
    private static final Set<String> SUPPORTED_URL_VARIABLES_REPOSITORY_SCOPE = ImmutableSet.builder().add((Object)"repo.slug").addAll(SUPPORTED_URL_VARIABLES_PROJECT_SCOPE).build();
    private static final Set<String> SUPPORTED_URL_VARIABLES_PULL_REQUEST_SCOPE = ImmutableSet.builder().add((Object)"pr.fromRef.branchName").add((Object)"pr.toRef.branchName").addAll(SUPPORTED_URL_VARIABLES_REPOSITORY_SCOPE).build();
    private static final Map<String, Set<String>> SUPPORTED_URL_VARIABLES_PER_SCOPE = ImmutableMap.builder().put((Object)"project", SUPPORTED_URL_VARIABLES_PROJECT_SCOPE).put((Object)"repo", SUPPORTED_URL_VARIABLES_REPOSITORY_SCOPE).put((Object)"mirror", SUPPORTED_URL_VARIABLES_REPOSITORY_SCOPE).put((Object)"pr", SUPPORTED_URL_VARIABLES_PULL_REQUEST_SCOPE).build();
    private static final Pattern URL_VARIABLE_PATTERN = Pattern.compile("(?<=\\{).*?(?=\\})");
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;

    public RestWebhooksResourceHelper(I18nService i18nService, PermissionValidationService permissionValidationService) {
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
    }

    public void validateScopeAdmin(WebhookScope webhookScope) {
        if (webhookScope instanceof WebhookScopeAdapter) {
            ((WebhookScopeAdapter)webhookScope).getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

                public Void visit(@Nonnull GlobalScope scope) {
                    RestWebhooksResourceHelper.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                    return null;
                }

                public Void visit(@Nonnull ProjectScope scope) {
                    RestWebhooksResourceHelper.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                    return null;
                }

                public Void visit(@Nonnull RepositoryScope scope) {
                    RestWebhooksResourceHelper.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                    return null;
                }
            });
        } else {
            this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        }
    }

    public void validateScopeTypes(List<String> scopeTypes) {
        if (!SUPPORTED_SCOPE_TYPES.containsAll(scopeTypes)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.webhooks.property.scopeType.invalid", new Object[]{scopeTypes}));
        }
    }

    public void validateWebhookUrl(Set<String> events, String url) {
        Matcher matcher = URL_VARIABLE_PATTERN.matcher(url);
        while (matcher.find()) {
            events.forEach(event -> {
                if ((event = StringUtils.trimToNull((String)event)) != null) {
                    String eventScope = StringUtils.split((String)event, (String)":", (int)2)[0];
                    if (!SUPPORTED_URL_VARIABLES_PER_SCOPE.containsKey(eventScope)) {
                        throw new BadRequestException("url", this.i18nService.getMessage("bitbucket.rest.webhooks.property.url.invalid", new Object[]{url}));
                    }
                    Set<String> supportedUrlVariables = SUPPORTED_URL_VARIABLES_PER_SCOPE.get(eventScope);
                    if (event.equals("repo:refs_changed")) {
                        supportedUrlVariables = SUPPORTED_URL_VARIABLES_REPOSITORY_PUSH_EVENT;
                    }
                    if (!supportedUrlVariables.contains(matcher.group())) {
                        throw new BadRequestException("url", this.i18nService.getMessage("bitbucket.rest.webhooks.property.url.invalid", new Object[]{url}));
                    }
                }
            });
        }
    }
}

