/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.webhook;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.enrich.EnrichProcessor;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.webhooks.internal.rest.RestWebhookScope;
import com.atlassian.webhooks.internal.rest.history.RestDetailedInvocation;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhooksResourceEnricher {
    private static final Logger log = LoggerFactory.getLogger(WebhooksResourceEnricher.class);
    private final RepositoryService repositoryService;

    public WebhooksResourceEnricher(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void enrich(@Nonnull Object entity) {
        EnrichProcessor.processEntities((Object)entity, toEnrich -> {
            if (toEnrich instanceof RestDetailedInvocation) {
                this.enrichInvocation((RestDetailedInvocation)toEnrich);
            }
            return toEnrich;
        });
    }

    private void enrichInvocation(RestDetailedInvocation entity) {
        try {
            Repository repository;
            RestWebhookScope eventScope = entity.getEventScope();
            String repositoryId = StringUtils.equals((CharSequence)"repository", (CharSequence)eventScope.getType()) ? eventScope.getId() : null;
            Repository repository2 = repository = repositoryId != null ? this.repositoryService.getById(Integer.parseInt(repositoryId)) : null;
            if (repository != null) {
                entity.put("repository", new RestRepository(repository));
            }
        }
        catch (AuthorisationException e) {
            log.debug("Skipping enrichment of RestDetailedInvocation with ID {} as it is not accessible to the current user", (Object)entity.getId());
        }
        catch (Exception e) {
            log.warn("Failed to enrich RestDetailedInvocation : {}", (Object)entity, (Object)e);
        }
    }
}

