/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.x509;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.x509.RestX509Certificate;
import com.atlassian.bitbucket.dmz.x509.DmzX509Certificate;
import com.atlassian.bitbucket.dmz.x509.DmzX509CertificateService;
import com.atlassian.bitbucket.dmz.x509.DmzX509CertificateSupplier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.stash.internal.rest.x509.FilePartX509CertificateSupplier;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.File;

@AdminOnly
@Path(value="signing/x509-certificates")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Security")
public class X509CertificateResource {
    private final I18nService i18nService;
    private final DmzX509CertificateService x509CertificateService;

    @Inject
    public X509CertificateResource(I18nService i18nService, DmzX509CertificateService x509CertificateService) {
        this.i18nService = i18nService;
        this.x509CertificateService = x509CertificateService;
    }

    @Operation(description="Create an X.509 certificate. This will add the given X.509 certificate to the system. Existing entries will not be overridden if an X.509 certificate already exists. Once added, an X.509 certificate cannot be updated.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Create an X.509 certificate")
    @RequestBody(description="The multipart form data containing the certificate in a form-field named 'certificate'", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExampleCertificateMultipartFormData.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created X.509 certificate", representation=RestX509Certificate.class, responseCode=201), @ResponseDoc(documentation="The authenticated user is not permitted to create X.509 certificates", responseCode=401, restError=true), @ResponseDoc(documentation="The request did not contain a valid X.509 certificate request. See returned error for more details", responseCode=400, restError=true)})
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json;charset=UTF-8"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createCertificate(@MultipartFormParam(value="certificate") FilePart certificate) {
        if (certificate == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.x509.create.no.certificate", new Object[0]));
        }
        DmzX509Certificate result = this.x509CertificateService.create((DmzX509CertificateSupplier)new FilePartX509CertificateSupplier(certificate));
        return Response.ok((Object)new RestX509Certificate(result)).build();
    }

    @Operation(description="Delete an X.509 certificate specified by the given ID.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Delete an X.509 certificate")
    @Parameters(value={@Parameter(description="The ID of the X.509 certificate.", in=ParameterIn.PATH, name="id")})
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response if the X.509 certificate was successfully deleted", representation=RestX509Certificate.class, responseCode=204), @ResponseDoc(documentation="There is no X.509 certificate with the given ID", responseCode=404, restError=true), @ResponseDoc(documentation="The authenticated user is not permitted to delete X.509 certificates", responseCode=401, restError=true)})
    @DELETE
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteCertificate(@PathParam(value="id") int id) {
        this.x509CertificateService.delete((long)id);
        return Response.noContent().build();
    }

    @Operation(description="Get all X.509 certificates that have been added to the system.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Get all X.509 certificates")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of X.509 certificates", representation=RestX509Certificate.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to get X.509 certificates", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllCertificates(@BeanParam PageRequestResolver pageRequestResolver) {
        Page certificates = this.x509CertificateService.findAll(pageRequestResolver.getPageRequest());
        return Response.ok().entity((Object)new RestPage(certificates, RestX509Certificate::new)).build();
    }

    @Operation(description="Update the certificate revocation list (CRL) entries for an issuer X.509 certificate in the system, identified by <code>id</code>. This will add any new revoked X.509 certificates that were issued by the given issuer X.509 certificate.\n\nThis endpoint will schedule a request to asynchronously perform the task. Please allow time for the task to complete as it will vary depending on how many CRLs there are to retrieve and process.\n\nNote: CRL updates are scheduled to run every 24 hours. You may wish to trigger a refresh manually using this endpoint, otherwise, entries will be updated daily.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Update X.509 CRL entries")
    @Parameters(value={@Parameter(description="The ID of the issuer certificate.", in=ParameterIn.PATH, name="id")})
    @ResponseDocs(value={@ResponseDoc(documentation="Successfully started processing CRLs.", responseCode=200), @ResponseDoc(documentation="There is no X.509 certificate with the given ID", responseCode=404, restError=true), @ResponseDoc(documentation="The authenticated user is not permitted to update X.509 CRL entries", responseCode=401, restError=true)})
    @PUT
    @Path(value="crl/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateCertificateRevocationListEntries(@PathParam(value="id") int id) {
        this.x509CertificateService.updateRevokedCertificates((long)id);
        return Response.ok().entity((Object)"Request successful. Please allow some time for processing to complete.").build();
    }

    private static class ExampleCertificateMultipartFormData {
        private ExampleCertificateMultipartFormData() {
        }

        @Schema(description="The X.509 certificate file to upload.")
        public File getCertificate() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

