/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.cache.CacheStatistics;
import com.atlassian.bitbucket.scm.cache.internal.InternalScmCacheService;
import com.atlassian.bitbucket.scm.cache.internal.SimpleCacheStatistics;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.event.api.EventListener;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScmCacheService
implements InternalScmCacheService {
    static final String NOTIFICATION_CLEAR_ALL = "all";
    static final String NOTIFICATION_TOPIC = "atl.bbs.scm-cache.caches";
    private static final Logger log = LoggerFactory.getLogger(DefaultScmCacheService.class);
    protected final Topic<String> topic;
    private final ApplicationMode applicationMode;
    private final ContentCacheManager cacheManager;
    private final PermissionValidationService validationService;
    private String subscriptionId;

    public DefaultScmCacheService(ContentCacheManager cacheManager, TopicService topicService, PermissionValidationService validationService, ApplicationModeSupplier applicationModeSupplier) {
        this.applicationMode = applicationModeSupplier.getMode();
        this.cacheManager = cacheManager;
        this.validationService = validationService;
        this.topic = this.applicationMode == ApplicationMode.MIRROR ? null : topicService.getTopic(NOTIFICATION_TOPIC, new TopicSettings.Builder(String.class).dedupePendingMessages(true).build());
    }

    @Override
    public void clear() {
        this.validationService.validateForGlobal(Permission.ADMIN);
        this.internalClear();
        if (this.topic != null) {
            this.topic.publish((Serializable)((Object)NOTIFICATION_CLEAR_ALL));
        }
    }

    @Override
    public void clear(@Nonnull Repository repository) {
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.doClear(repository, null);
    }

    @Override
    public void clear(@Nonnull Repository repository, @Nonnull String cacheKey) {
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.doClear(repository, Objects.requireNonNull(cacheKey, "cacheKey"));
    }

    @Override
    public void clearByPrefix(@Nonnull Repository repository, @Nonnull String prefix) {
        this.clear(repository, Objects.requireNonNull(prefix, "prefix") + "*");
    }

    public void destroy() {
        if (this.subscriptionId != null) {
            this.topic.unsubscribe(this.subscriptionId);
        }
    }

    @Override
    @Nonnull
    public ContentCache getCache(@Nonnull Repository repository) {
        return this.cacheManager.getCache(DefaultScmCacheService.getCacheRegion(repository));
    }

    @Override
    @Nonnull
    public CacheStatistics getStatistics() {
        this.validationService.validateForGlobal(Permission.ADMIN);
        return new SimpleCacheStatistics(this.cacheManager.getStatistics());
    }

    @Override
    public CacheStatistics getStatistics(@Nonnull Repository repository) {
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        return new SimpleCacheStatistics(this.getCache(repository).getStatistics());
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (this.applicationMode == ApplicationMode.MIRROR) {
            return;
        }
        log.trace("Received ClusterNodeAddedEvent; clearing local caches");
        this.internalClear();
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        log.trace("Received RepositoryDeletedEvent; clearing cache for repository {}", (Object)event.getRepository());
        this.doClear(event.getRepository(), null);
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        log.trace("Received RepositoryRefsChangedEvent; clearing cache for repository {}", (Object)event.getRepository());
        this.doClear(event.getRepository(), null);
    }

    public void init() {
        if (this.topic == null) {
            return;
        }
        this.subscriptionId = this.topic.subscribe(message -> {
            if (message.getSource().isLocal()) {
                return;
            }
            String notification = (String)message.getMessage();
            if (NOTIFICATION_CLEAR_ALL.equals(notification)) {
                this.internalClear();
            } else {
                int index = notification.indexOf(47);
                if (index == -1) {
                    this.internalClear(notification, null);
                } else {
                    String region = notification.substring(0, index);
                    String cacheKey = notification.substring(index + 1);
                    this.internalClear(region, cacheKey);
                }
            }
        });
    }

    protected void internalClear() {
        this.cacheManager.clear();
    }

    protected void internalClear(String region, String key) {
        ContentCache cache = this.cacheManager.getCache(region);
        if (key == null) {
            cache.clear();
        } else if (key.endsWith("*")) {
            String prefix = key.substring(0, key.length() - 1);
            Set<String> toPrune = cache.getEntries().keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toSet());
            toPrune.forEach(arg_0 -> ((ContentCache)cache).remove(arg_0));
        } else {
            cache.remove(key);
        }
    }

    @VisibleForTesting
    static String getCacheRegion(Repository repository) {
        return String.valueOf(Objects.requireNonNull(repository, "repository").getId());
    }

    private void doClear(Repository repository, String cacheKey) {
        String region = DefaultScmCacheService.getCacheRegion(repository);
        this.internalClear(region, cacheKey);
        if (this.topic != null) {
            this.topic.publish((Serializable)(cacheKey == null ? region : region + "/" + cacheKey));
        }
    }
}

