/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcClearPackCacheRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.cache.CacheStatistics;
import com.atlassian.bitbucket.scm.cache.internal.DefaultScmCacheService;
import com.atlassian.bitbucket.scm.cache.internal.SimpleCacheStatistics;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.scm.git.mesh.PackCacheStatistics;
import com.atlassian.stash.internal.scm.git.mesh.RpcPackCacheClient;
import com.atlassian.util.contentcache.ContentCacheManager;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshScmCacheService
extends DefaultScmCacheService {
    private static final Logger log = LoggerFactory.getLogger(MeshScmCacheService.class);
    private final ExecutorService executorService;
    private final RpcPackCacheClient packCacheClient;
    private final RepositoryService repositoryService;
    private final boolean sidecarEnabled;
    private final EscalatedSecurityContext withRepoRead;

    public MeshScmCacheService(ContentCacheManager cacheManager, ExecutorService executorService, RpcPackCacheClient packCacheClient, RepositoryService repositoryService, SecurityService securityService, boolean sidecarEnabled, TopicService topicService, PermissionValidationService validationService, ApplicationModeSupplier applicationModeSupplier) {
        super(cacheManager, topicService, validationService, applicationModeSupplier);
        this.executorService = executorService;
        this.packCacheClient = packCacheClient;
        this.repositoryService = repositoryService;
        this.sidecarEnabled = sidecarEnabled;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "Clearing SCM cache");
    }

    @Override
    @Nonnull
    public CacheStatistics getStatistics() {
        return MeshScmCacheService.cacheStatistics(this.packCacheClient.getStatistics(null));
    }

    @Override
    public CacheStatistics getStatistics(@Nonnull Repository repository) {
        return MeshScmCacheService.cacheStatistics(this.packCacheClient.getStatistics(repository));
    }

    @Override
    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (this.sidecarEnabled) {
            this.executorService.submit(() -> ((RpcPackCacheClient)this.packCacheClient).clearSidecar());
        }
    }

    @Override
    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.onRepositoryChanged(event.getRepository());
    }

    @Override
    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        this.onRepositoryChanged(event.getRepository());
    }

    @Override
    protected void internalClear() {
        super.internalClear();
        this.clearPackCache(RpcClearPackCacheRequest.newBuilder(), null);
    }

    @Override
    protected void internalClear(String region, String key) {
        super.internalClear(region, key);
        Repository repository = (Repository)this.withRepoRead.call(() -> this.repositoryService.getById(Integer.parseInt(region)));
        if (repository == null) {
            log.info("Unable to clear cache as repository {} was not found.", (Object)region);
            return;
        }
        if (repository.isRemote() || this.sidecarEnabled) {
            RpcClearPackCacheRequest.Builder builder = RpcClearPackCacheRequest.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)key)) {
                builder.setCacheKey(key);
            }
            this.clearPackCache(builder, repository);
        } else {
            log.trace("[{}] Cache invalidation for local repositories is skipped in mixed mode", (Object)repository);
        }
    }

    private void clearPackCache(RpcClearPackCacheRequest.Builder builder, Repository repository) {
        if (repository == null || repository.isRemote() || this.sidecarEnabled) {
            this.packCacheClient.clear(repository, builder);
        }
    }

    private void onRepositoryChanged(Repository repository) {
        if (this.topic != null && repository.isLocal() && this.sidecarEnabled) {
            this.topic.publish((Serializable)((Object)MeshScmCacheService.getCacheRegion(repository)));
        }
    }

    private static CacheStatistics cacheStatistics(PackCacheStatistics statistics) {
        return new SimpleCacheStatistics(statistics.getHits(), statistics.getMisses(), statistics.getSizeInMemory());
    }
}

