/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal;

import com.atlassian.bitbucket.scm.cache.ScmCacheConfig;
import com.atlassian.bitbucket.scm.cache.ScmRequestType;
import com.atlassian.util.contentcache.CacheEntry;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.TtlCacheExpiryStrategy;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class ScmCacheExpiryStrategy
extends TtlCacheExpiryStrategy {
    private static final Comparator<CacheEntry> ENTRY_COMPARATOR = Comparator.comparing(cacheEntry -> cacheEntry.getStatistics().getLastAccessedDate()).thenComparing(cacheEntry -> cacheEntry.getStatistics().getKey());
    private final ScmCacheConfig config;

    public ScmCacheExpiryStrategy(ScmCacheConfig config) {
        this.config = config;
    }

    @Nonnull
    public Iterable<CacheEntry> getExpiredEntries(@Nonnull ContentCache cache) {
        HashMap<ScmRequestType, TreeSet> entriesByType = new HashMap<ScmRequestType, TreeSet>();
        HashSet expired = Sets.newHashSet();
        for (Map.Entry entry : cache.getEntries().entrySet()) {
            if (this.isExpired((CacheEntry)entry.getValue())) {
                expired.add((CacheEntry)entry.getValue());
                continue;
            }
            ScmRequestType requestType = this.getType((String)entry.getKey());
            if (requestType == null) continue;
            entriesByType.computeIfAbsent(requestType, k -> new TreeSet<CacheEntry>(ENTRY_COMPARATOR)).add((CacheEntry)entry.getValue());
        }
        for (Map.Entry entry : entriesByType.entrySet()) {
            int toBeRemoved = ((TreeSet)entry.getValue()).size() - this.config.getMaxCount((ScmRequestType)((Object)entry.getKey()));
            Iterator it = ((TreeSet)entry.getValue()).iterator();
            while (toBeRemoved-- > 0) {
                expired.add((CacheEntry)it.next());
            }
        }
        return expired;
    }

    private ScmRequestType getType(String key) {
        if (key.contains("clone|")) {
            return ScmRequestType.UPLOAD_PACK;
        }
        return null;
    }
}

