/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal;

import com.atlassian.bitbucket.scm.cache.CacheStatistics;
import com.atlassian.bitbucket.scm.cache.ScmCacheConfig;
import com.atlassian.bitbucket.scm.cache.ScmCacheService;
import com.atlassian.bitbucket.scm.cache.ScmRequestProtocol;
import com.atlassian.bitbucket.scm.cache.ScmRequestType;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;

public class ScmCacheSupportData
extends RootLevelSupportDataAppender {
    private static final String CACHE_PREFIX = "bitbucket.atst.git.cache.";
    private static final String ENABLED = "bitbucket.atst.git.cache.enabled";
    private static final String PROTOCOL_HTTP_ENABLED = "bitbucket.atst.git.cache.protocol.http.enabled";
    private static final String PROTOCOL_SSH_ENABLED = "bitbucket.atst.git.cache.protocol.ssh.enabled";
    private static final String SECTION = "bitbucket.atst.git.cache.section";
    private static final String STATISTICS_PREFIX = "bitbucket.atst.git.cache.statistics.";
    private static final String STATISTICS_HITS = "bitbucket.atst.git.cache.statistics.hits";
    private static final String STATISTICS_MISSES = "bitbucket.atst.git.cache.statistics.misses";
    private static final String STATISTICS_SECTION = "bitbucket.atst.git.cache.statistics.section";
    private static final String STATISTICS_SIZE = "bitbucket.atst.git.cache.statistics.size-on-disk";
    private static final String TTL = "bitbucket.atst.git.cache.ttl";
    private static final String UPLOAD_PACK = "bitbucket.atst.git.cache.upload-pack";
    private final ScmCacheService cacheService;
    private final ScmCacheConfig config;

    public ScmCacheSupportData(ScmCacheService cacheService, ScmCacheConfig config) {
        this.cacheService = cacheService;
        this.config = config;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder builder = supportDataBuilder.addCategory(SECTION).addValue(PROTOCOL_HTTP_ENABLED, Boolean.toString(this.config.isEnabled(ScmRequestProtocol.HTTP))).addValue(PROTOCOL_SSH_ENABLED, Boolean.toString(this.config.isEnabled(ScmRequestProtocol.SSH)));
        builder.addCategory(UPLOAD_PACK).addValue(ENABLED, Boolean.toString(this.config.isEnabled(ScmRequestType.UPLOAD_PACK))).addValue(TTL, Long.toString(this.config.getTimeToLive(ScmRequestType.UPLOAD_PACK)));
        CacheStatistics statistics = this.cacheService.getStatistics();
        builder.addCategory(STATISTICS_SECTION).addValue(STATISTICS_HITS, Long.toString(statistics.getHits())).addValue(STATISTICS_MISSES, Long.toString(statistics.getMisses())).addValue(STATISTICS_SIZE, Long.toString(statistics.getSize()));
    }
}

