/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryCloneEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.util.contentcache.CacheResult;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.repository.cloned")
public class AnalyticsRepositoryCloneEvent
extends RepositoryCloneEvent {
    private final long bytesRead;
    private final long bytesWritten;
    private final CacheResult cacheResult;
    private final long duration;
    private final String protocol;

    public AnalyticsRepositoryCloneEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull RequestContext requestContext, @Nonnull String protocol, @Nonnull CacheResult cacheResult) {
        super(source, repository);
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(requestContext, "requestContext");
        this.cacheResult = Objects.requireNonNull(cacheResult, "cacheResult");
        this.protocol = protocol.equals("http") || protocol.equals("ssh") ? protocol.toLowerCase(Locale.ROOT) : "other";
        this.bytesRead = requestContext.getBytesRead();
        this.bytesWritten = requestContext.getBytesWritten();
        this.duration = requestContext.getDuration().map(Duration::toMillis).orElse(0L);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Nonnull
    public CacheResult getCacheResult() {
        return this.cacheResult;
    }

    public long getDuration() {
        return this.duration;
    }

    @Nonnull
    public String getProtocol() {
        return this.protocol;
    }
}

