/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryPullEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.repository.pulled")
public class AnalyticsRepositoryPullEvent
extends RepositoryPullEvent {
    private final long bytesRead;
    private final long bytesWritten;
    private final long duration;
    private final String protocol;

    public AnalyticsRepositoryPullEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull RequestContext requestContext, @Nonnull String protocol) {
        super(source, repository);
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(requestContext, "requestContext");
        this.protocol = protocol.equals("http") || protocol.equals("ssh") ? protocol.toLowerCase(Locale.ROOT) : "other";
        this.bytesRead = requestContext.getBytesRead();
        this.bytesWritten = requestContext.getBytesWritten();
        this.duration = requestContext.getDuration().map(Duration::toMillis).orElse(0L);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getDuration() {
        return this.duration;
    }

    @Nonnull
    public String getProtocol() {
        if (this.protocol.equalsIgnoreCase("http") || this.protocol.equalsIgnoreCase("ssh")) {
            return this.protocol.toLowerCase();
        }
        return "other";
    }
}

