/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal.jmx;

import com.atlassian.bitbucket.scm.cache.internal.jmx.HostingStatisticsMXBean;
import com.atlassian.util.contentcache.CacheResult;
import java.util.concurrent.atomic.AtomicLong;

public class HostingStatistics
implements HostingStatisticsMXBean {
    private final AtomicLong cloneCacheBypass = new AtomicLong();
    private final AtomicLong cloneCacheHit = new AtomicLong();
    private final AtomicLong cloneCacheMiss = new AtomicLong();
    private final AtomicLong cloneRead = new AtomicLong();
    private final AtomicLong cloneRequestCount = new AtomicLong();
    private final AtomicLong cloneWritten = new AtomicLong();
    private final AtomicLong fetchRead = new AtomicLong();
    private final AtomicLong fetchRequestCount = new AtomicLong();
    private final AtomicLong fetchWritten = new AtomicLong();
    private final AtomicLong requests = new AtomicLong();

    @Override
    public long getCloneBytesRead() {
        return this.cloneRead.get();
    }

    @Override
    public long getCloneBytesWritten() {
        return this.cloneWritten.get();
    }

    @Override
    public long getCloneCacheBypass() {
        return this.cloneCacheBypass.get();
    }

    @Override
    public long getCloneCacheHit() {
        return this.cloneCacheHit.get();
    }

    @Override
    public long getCloneCacheMiss() {
        return this.cloneCacheMiss.get();
    }

    @Override
    public long getCloneRequestCount() {
        return this.cloneRequestCount.get();
    }

    @Override
    public long getFetchBytesRead() {
        return this.fetchRead.get();
    }

    @Override
    public long getFetchBytesWritten() {
        return this.fetchWritten.get();
    }

    @Override
    public long getFetchRequestCount() {
        return this.fetchRequestCount.get();
    }

    @Override
    public long getRequestCount() {
        return this.requests.get();
    }

    @Override
    public long getTotalBytesRead() {
        return this.cloneRead.get() + this.fetchRead.get();
    }

    @Override
    public long getTotalBytesWritten() {
        return this.cloneWritten.get() + this.fetchWritten.get();
    }

    @Override
    public void reset() {
        this.cloneCacheBypass.set(0L);
        this.cloneCacheHit.set(0L);
        this.cloneCacheMiss.set(0L);
        this.cloneRead.set(0L);
        this.cloneRequestCount.set(0L);
        this.cloneWritten.set(0L);
        this.fetchRead.set(0L);
        this.fetchRequestCount.set(0L);
        this.fetchWritten.set(0L);
        this.requests.set(0L);
    }

    void updateClone(long bytesRead, long bytesWritten, CacheResult cacheResult) {
        this.requests.incrementAndGet();
        this.cloneRequestCount.incrementAndGet();
        this.cloneRead.addAndGet(bytesRead);
        this.cloneWritten.addAndGet(bytesWritten);
        switch (cacheResult) {
            case HIT: {
                this.cloneCacheHit.incrementAndGet();
                break;
            }
            case MISS: {
                this.cloneCacheMiss.incrementAndGet();
                break;
            }
            case BYPASS: {
                this.cloneCacheBypass.incrementAndGet();
                break;
            }
        }
    }

    void updateFetch(long bytesRead, long bytesWritten) {
        this.requests.incrementAndGet();
        this.fetchRequestCount.incrementAndGet();
        this.fetchRead.addAndGet(bytesRead);
        this.fetchWritten.addAndGet(bytesWritten);
    }
}

