/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal.jmx;

import com.atlassian.bitbucket.scm.cache.internal.event.AnalyticsRepositoryCloneEvent;
import com.atlassian.bitbucket.scm.cache.internal.event.AnalyticsRepositoryPullEvent;
import com.atlassian.bitbucket.scm.cache.internal.jmx.HostingStatistics;
import com.atlassian.event.api.EventListener;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmHostingStatistics {
    private static final Logger log = LoggerFactory.getLogger(ScmHostingStatistics.class);
    private final HostingStatistics httpStatistics = new HostingStatistics();
    private final HostingStatistics sshStatistics = new HostingStatistics();

    public ScmHostingStatistics() {
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            platformMBeanServer.registerMBean(this.httpStatistics, new ObjectName("com.atlassian.bitbucket:name=HttpHostingStatistics"));
            platformMBeanServer.registerMBean(this.sshStatistics, new ObjectName("com.atlassian.bitbucket:name=SshHostingStatistics"));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Could not register HostingStatistics MXBeans. Hosting statistics will not be available in JMX", (Throwable)e);
        }
    }

    @EventListener
    public void onRepositoryCloneEvent(AnalyticsRepositoryCloneEvent event) {
        if ("http".equals(event.getProtocol())) {
            this.httpStatistics.updateClone(event.getBytesRead(), event.getBytesWritten(), event.getCacheResult());
        } else {
            this.sshStatistics.updateClone(event.getBytesRead(), event.getBytesWritten(), event.getCacheResult());
        }
    }

    @EventListener
    public void onRepositoryPullEvent(AnalyticsRepositoryPullEvent event) {
        if ("http".equals(event.getProtocol())) {
            this.httpStatistics.updateFetch(event.getBytesRead(), event.getBytesWritten());
        } else {
            this.sshStatistics.updateFetch(event.getBytesRead(), event.getBytesWritten());
        }
    }
}

