/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.cache.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshConfigProvider;
import com.atlassian.bitbucket.dmz.mesh.MeshConfigUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.scm.cache.ScmRequestProtocol;
import com.atlassian.bitbucket.scm.cache.ScmRequestType;
import com.atlassian.bitbucket.scm.cache.internal.DefaultScmCacheService;
import com.atlassian.bitbucket.scm.cache.internal.InternalScmCacheConfig;
import com.atlassian.bitbucket.scm.cache.internal.UnsupportedRequestTypeException;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshScmCacheConfig
implements InternalScmCacheConfig,
MeshConfigProvider {
    static final long ONE_GB = 0x40000000L;
    static final long DEFAULT_EVICTION_FREE_SPACE = 0x180000000L;
    static final long DEFAULT_EVICTION_HYSTERESIS = 0x40000000L;
    static final long DEFAULT_EXPIRY_CHECK_INTERVAL = 30L;
    static final long DEFAULT_MIN_FREE_SPACE = 0x140000000L;
    static final String DEFAULT_PROTOCOLS = "HTTP,SSH";
    static final int DEFAULT_UPLOAD_PACK_MAX = 20;
    static final long DEFAULT_UPLOAD_PACK_TTL = TimeUnit.HOURS.toSeconds(4L);
    private static final String KEY_PROTOCOLS = "protocols";
    private static final Logger log = LoggerFactory.getLogger(DefaultScmCacheService.class);
    private final Path[] cacheDirs;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final Set<String> loggedWarningsForKeys;
    private final PluginSettings pluginSettings;
    private final ApplicationPropertiesService propertiesService;
    private final PermissionValidationService validationService;

    public MeshScmCacheConfig(EventPublisher eventPublisher, I18nService i18nService, PluginSettingsFactory pluginSettingsFactory, ApplicationPropertiesService propertiesService, StorageService storageService, PermissionValidationService validationService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
        this.validationService = validationService;
        this.loggedWarningsForKeys = new HashSet<String>();
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-scm-cache");
        Path cacheDir = storageService.getCacheDir();
        this.cacheDirs = new Path[]{cacheDir.resolve("scm"), cacheDir.resolve("scm-cache"), cacheDir.resolve("clone-cache")};
    }

    @Override
    public Date createExpiryDate(@Nonnull ScmRequestType requestType) {
        long ttl = this.getTimeToLive(requestType);
        return ttl > 0L ? new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttl)) : null;
    }

    public void destroy() {
        this.deleteCacheDirs();
    }

    @Override
    @Nonnull
    public Path getCacheDir() {
        return this.cacheDirs[0];
    }

    public void mergeConfig(@Nonnull MeshConfigProvider.ConfigBuilder propertiesBuilder) {
        String protocols = this.loadProperty(KEY_PROTOCOLS).orElse(DEFAULT_PROTOCOLS);
        propertiesBuilder.put("hosting.cache.minimum.free.space", (Object)this.getMinimumFreeSpace()).put("hosting.cache.pack.enabled", (Object)this.isEnabled(ScmRequestType.UPLOAD_PACK)).put("hosting.cache.pack.maxCount", (Object)this.getMaxCount(ScmRequestType.UPLOAD_PACK)).put("hosting.cache.pack.ttl", (Object)this.getTimeToLive(ScmRequestType.UPLOAD_PACK)).put("hosting.cache.protocol.http.enabled", (Object)protocols.contains("HTTP")).put("hosting.cache.protocol.ssh.enabled", (Object)protocols.contains("SSH"));
    }

    @Override
    @Nonnull
    public Set<ScmRequestProtocol> getEnabledProtocols() {
        EnumSet<ScmRequestProtocol> protocols = EnumSet.noneOf(ScmRequestProtocol.class);
        String property = this.loadProperty(KEY_PROTOCOLS).map(String::toUpperCase).orElse(DEFAULT_PROTOCOLS);
        if (property.contains("HTTP")) {
            protocols.add(ScmRequestProtocol.HTTP);
        }
        if (property.contains("SSH")) {
            protocols.add(ScmRequestProtocol.SSH);
        }
        return protocols;
    }

    @Override
    public long getEvictionFreeSpace() {
        return this.propertiesService.getPluginProperty("plugin.bitbucket-scm-cache.eviction.trigger.free.space", 0x180000000L);
    }

    @Override
    public long getEvictionHysteresis() {
        return this.propertiesService.getPluginProperty("plugin.bitbucket-scm-cache.eviction.hysteresis", 0x40000000L);
    }

    @Override
    @Nonnull
    public Duration getExpiryCheckInterval() {
        return Duration.ofSeconds(this.propertiesService.getPluginProperty("plugin.bitbucket-scm-cache.expiry.check.interval", 30L));
    }

    @Override
    public int getMaxCount(@Nonnull ScmRequestType requestType) {
        Objects.requireNonNull(requestType, "requestType");
        if (requestType == ScmRequestType.UPLOAD_PACK) {
            return this.loadProperty("upload-pack.maxCount").map(Integer::valueOf).orElse(20);
        }
        return 0;
    }

    @Override
    public long getMinimumFreeSpace() {
        return this.propertiesService.getPluginProperty("plugin.bitbucket-scm-cache.minimum.free.space", 0x140000000L);
    }

    @Override
    public long getTimeToLive(@Nonnull ScmRequestType requestType) {
        Objects.requireNonNull(requestType, "requestType");
        if (requestType == ScmRequestType.UPLOAD_PACK) {
            return this.loadProperty("upload-pack.ttl").map(Long::valueOf).orElse(DEFAULT_UPLOAD_PACK_TTL);
        }
        return 0L;
    }

    public void init() {
        this.deleteCacheDirs();
    }

    @Override
    public boolean isEnabled(@Nonnull ScmRequestType requestType) {
        Objects.requireNonNull(requestType, "requestType");
        if (requestType == ScmRequestType.UPLOAD_PACK) {
            return this.loadProperty("upload-pack.enabled").map(Boolean::valueOf).orElse(true);
        }
        return false;
    }

    @Override
    public boolean isEnabled(@Nonnull ScmRequestProtocol protocol) {
        String protocols = this.loadProperty(KEY_PROTOCOLS).orElse(DEFAULT_PROTOCOLS);
        return protocols.contains(Objects.requireNonNull(protocol, "protocol").name());
    }

    @Override
    public boolean isEnabledForProtocol(@Nonnull ScmRequestType type, @Nonnull ScmRequestProtocol protocol) {
        return this.isEnabled(Objects.requireNonNull(type, "type")) && this.isEnabled(Objects.requireNonNull(protocol, "protocol"));
    }

    public void requireUploadPack(@Nonnull ScmRequestType requestType) {
        Objects.requireNonNull(requestType, "requestType");
        if (requestType != ScmRequestType.UPLOAD_PACK) {
            throw new UnsupportedRequestTypeException(this.i18nService.createKeyedMessage("bitbucket.scm.cache.request.type.unsupported", new Object[]{requestType}));
        }
    }

    @Override
    public void setEnabled(@Nonnull ScmRequestType requestType, boolean enabled) {
        this.requireUploadPack(requestType);
        this.validationService.validateForGlobal(Permission.ADMIN);
        this.pluginSettings.put("upload-pack.enabled", (Object)Boolean.toString(enabled));
        this.eventPublisher.publish((Object)new MeshConfigUpdatedEvent((Object)this, (MeshConfigProvider)this));
        this.maybeLogWarning(requestType.getName());
    }

    @Override
    public void setEnabled(@Nonnull ScmRequestProtocol protocol, boolean enabled) {
        this.validationService.validateForGlobal(Permission.ADMIN);
        Objects.requireNonNull(protocol, "protocol");
        Set<ScmRequestProtocol> enabledProtocols = this.getEnabledProtocols();
        if (enabled ? enabledProtocols.add(protocol) : enabledProtocols.remove((Object)protocol)) {
            if (enabledProtocols.isEmpty()) {
                this.pluginSettings.put(KEY_PROTOCOLS, (Object)"NONE");
            } else {
                this.pluginSettings.put(KEY_PROTOCOLS, (Object)StringUtils.join(enabledProtocols, (String)","));
            }
            this.eventPublisher.publish((Object)new MeshConfigUpdatedEvent((Object)this, (MeshConfigProvider)this));
            this.maybeLogWarning(KEY_PROTOCOLS);
        }
    }

    @Override
    public void setMaxCount(@Nonnull ScmRequestType requestType, int maxCount) {
        this.requireUploadPack(requestType);
        this.validationService.validateForGlobal(Permission.ADMIN);
        this.pluginSettings.put("upload-pack.maxCount", (Object)Integer.toString(maxCount));
        this.eventPublisher.publish((Object)new MeshConfigUpdatedEvent((Object)this, (MeshConfigProvider)this));
        this.maybeLogWarning(requestType.getName());
    }

    @Override
    public void setTimeToLive(@Nonnull ScmRequestType requestType, long timeToLiveSeconds) {
        this.requireUploadPack(requestType);
        this.validationService.validateForGlobal(Permission.ADMIN);
        this.pluginSettings.put("upload-pack.ttl", (Object)Long.toString(timeToLiveSeconds));
        this.eventPublisher.publish((Object)new MeshConfigUpdatedEvent((Object)this, (MeshConfigProvider)this));
        this.maybeLogWarning(requestType.getName());
    }

    private void deleteCacheDirs() {
        for (Path cacheDir : this.cacheDirs) {
            try {
                MoreFiles.deleteRecursively((Path)cacheDir);
            }
            catch (IOException e) {
                log.warn("Could not clear {} directory: {}", new Object[]{cacheDir.getFileName(), e.getMessage(), log.isDebugEnabled() ? e : null});
            }
        }
    }

    private Optional<String> loadProperty(String name) {
        String propertyKey = "plugin.bitbucket-scm-cache." + name;
        String pluginProperty = this.propertiesService.getPluginProperty(propertyKey);
        Object setting = this.pluginSettings.get(name);
        if (setting instanceof String) {
            if (pluginProperty != null && !pluginProperty.equals(setting) && this.loggedWarningsForKeys.add(name)) {
                log.info("Property '{}' has been overridden using the REST API and will be ignored. Please use the REST API to update the setting if needed.", (Object)propertyKey);
            }
            return Optional.of((String)setting);
        }
        return Optional.ofNullable(pluginProperty);
    }

    private void maybeLogWarning(@Nonnull String name) {
        String propertyKey = "plugin.bitbucket-scm-cache." + name;
        String property = this.propertiesService.getPluginProperty(propertyKey);
        if (property != null) {
            log.warn("The SCM Cache configuration for '{}' was changed while the application is running. This will override the '{}' property. Removing the property from the properties file is recommended.", (Object)name, (Object)propertyKey);
        }
    }
}

