/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lookandfeel.impl;

import com.atlassian.lookandfeel.spi.internal.LookAndFeelVariablesProvider;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.transformer.TransformableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.MurmurHash3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssTransformer
implements WebResourceTransformerFactory {
    private final Logger log;
    private final Set<LookAndFeelVariablesProvider> importedLookAndFeelVariablesProviders;

    public CssTransformer(Set<LookAndFeelVariablesProvider> importedLookAndFeelVariablesProviders) {
        this(importedLookAndFeelVariablesProviders, LoggerFactory.getLogger(CssTransformer.class));
    }

    public CssTransformer(Set<LookAndFeelVariablesProvider> importedLookAndFeelVariablesProviders, Logger log) {
        this.importedLookAndFeelVariablesProviders = Objects.requireNonNull(importedLookAndFeelVariablesProviders, "lookAndFeelVariablesProvider");
        this.log = Objects.requireNonNull(log, "log");
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return new LookAndFeelTransformer();
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return new LookAndFeelTransformerUrlBuilder();
    }

    private LookAndFeelVariablesProvider getConcreteLookAndFeelProvider() {
        if (this.importedLookAndFeelVariablesProviders.size() > 1) {
            throw new IllegalStateException("There is more than a single LookAndFeelVariablesProvider exported as an OSGi service");
        }
        if (this.importedLookAndFeelVariablesProviders.isEmpty()) {
            return new LookAndFeelVariablesProvider(){

                @Override
                public Map<String, String> getLightModeVariables() {
                    return Collections.emptyMap();
                }

                @Override
                public Map<String, String> getDarkModeVariables() {
                    return Collections.emptyMap();
                }
            };
        }
        return (LookAndFeelVariablesProvider)this.importedLookAndFeelVariablesProviders.stream().findFirst().get();
    }

    private class LookAndFeelTransformer
    implements UrlReadingWebResourceTransformer {
        private static final String CSS_LIGHT_MODE = "/* light mode */\nhtml:not([data-color-mode-auto])[data-color-mode=\"dark\"][data-theme~=\"dark:light\"],\nhtml:not([data-color-mode-auto])[data-color-mode=\"light\"],\nhtml:not([data-color-mode-auto]):not([data-color-mode]) {\n%1$s\n}\n@media (prefers-color-scheme: light) {\n    html[data-color-mode-auto] {\n    %1$s\n    }\n}\n";
        private static final String CSS_DARK_MODE = "/* dark mode */\nhtml:not([data-color-mode-auto])[data-color-mode=\"light\"][data-theme~=\"light:dark\"],\nhtml:not([data-color-mode-auto])[data-color-mode=\"dark\"] {\n%1$s\n}\n@media (prefers-color-scheme: dark) {\n    html[data-color-mode-auto] {\n    %1$s\n    }\n}\n";

        private LookAndFeelTransformer() {
        }

        public DownloadableResource transform(TransformableResource resource, QueryParams params) {
            DownloadableResource original = resource.nextResource();
            return new CharSequenceDownloadableResource(original){

                protected CharSequence transform(CharSequence input) {
                    Object content = input.toString();
                    Map<String, String> lightVariables = CssTransformer.this.getConcreteLookAndFeelProvider().getLightModeVariables();
                    Map<String, String> darkVariables = CssTransformer.this.getConcreteLookAndFeelProvider().getDarkModeVariables();
                    if (!lightVariables.keySet().equals(darkVariables.keySet())) {
                        content = "\n/* WARNING: Light and dark mode variables have mismatched keys */\n" + (String)content;
                        HashSet<String> lightOnly = new HashSet<String>(lightVariables.keySet());
                        lightOnly.removeAll(darkVariables.keySet());
                        HashSet<String> darkOnly = new HashSet<String>(darkVariables.keySet());
                        darkOnly.removeAll(lightVariables.keySet());
                        String details = String.format("Light mode only: %s, Dark mode only: %s", String.join((CharSequence)", ", lightOnly), String.join((CharSequence)", ", darkOnly));
                        CssTransformer.this.log.warn("Mismatched CSS variable keys between light and dark modes. {}", (Object)details);
                    }
                    return String.join((CharSequence)"\n", new CharSequence[]{content, LookAndFeelTransformer.this.generateCSS(LookAndFeelTransformer.CSS_LIGHT_MODE, new TreeMap<String, String>(CssTransformer.this.getConcreteLookAndFeelProvider().getLightModeVariables())), LookAndFeelTransformer.this.generateCSS(LookAndFeelTransformer.CSS_DARK_MODE, new TreeMap<String, String>(CssTransformer.this.getConcreteLookAndFeelProvider().getDarkModeVariables()))});
                }
            };
        }

        private String generateCSS(String cssTemplate, Map<String, String> variables) {
            String cssVariables = variables.entrySet().stream().map(entry -> "  " + (String)entry.getKey() + ": " + (String)entry.getValue() + ";").collect(Collectors.joining("\n"));
            return String.format(cssTemplate, cssVariables);
        }
    }

    private class LookAndFeelTransformerUrlBuilder
    implements TransformerUrlBuilder {
        private LookAndFeelTransformerUrlBuilder() {
        }

        public void addToUrl(UrlBuilder urlBuilder) {
            String content = this.generateContent();
            String hash = this.calculateHash(content);
            urlBuilder.addToQueryString("lnf-css-hash", hash);
        }

        private String generateContent() {
            return String.join((CharSequence)"", this.generateModeContent("LIGHT::", CssTransformer.this.getConcreteLookAndFeelProvider().getDarkModeVariables()), this.generateModeContent("DARK::", CssTransformer.this.getConcreteLookAndFeelProvider().getDarkModeVariables()));
        }

        private String generateModeContent(String prefix, Map<String, String> variables) {
            return prefix + variables.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(";"));
        }

        private String calculateHash(String input) {
            byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
            long[] hash = MurmurHash3.hash128x64((byte[])bytes);
            byte[] hashBytes = new byte[16];
            ByteBuffer.wrap(hashBytes).putLong(hash[0]).putLong(hash[1]);
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hashBytes);
        }
    }
}

