/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.azuread;

import com.atlassian.crowd.directory.rest.endpoint.DefaultRegion;
import com.atlassian.crowd.directory.synchronisation.cache.AzureFilteringEnabledCheckerImpl;
import com.atlassian.crowd.embedded.admin.ConfigurationController;
import com.atlassian.crowd.embedded.admin.azuread.AzureAdConfigurationValidator;
import com.atlassian.crowd.embedded.admin.azuread.AzureAdDirectoryConfiguration;
import com.atlassian.crowd.embedded.api.Directory;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/configure/azuread/**"})
public class AzureAdConfigurationController
extends ConfigurationController<AzureAdDirectoryConfiguration> {
    private static final String FORM_VIEW = "configure-azuread-form";
    private static final String SUCCESS_VIEW = "redirect:/plugins/servlet/embedded-crowd/directories/troubleshoot?directoryId={directoryId}&forceTest=true";
    public static final List<DefaultRegion> NON_DEFAULT_REGIONS = Arrays.asList(DefaultRegion.UNITED_STATES_GOVERNMENT, DefaultRegion.CHINA);
    @Autowired
    private AzureFilteringEnabledCheckerImpl azureFilteringEnabledChecker;

    @InitBinder
    protected void initRequiredFields(WebDataBinder binder) {
        binder.setRequiredFields(new String[]{"name", "tenantId", "graphEndpoint", "authorityEndpoint", "webAppId", "nativeAppId"});
    }

    @InitBinder(value={"configuration"})
    protected void initConfigurationValidator(WebDataBinder binder) {
        binder.setValidator((Validator)new AzureAdConfigurationValidator());
        binder.getBindingResult();
    }

    @ModelAttribute(value="regions")
    public Map<String, String> addAzureADRegionsMap() {
        boolean allRegions = this.darkFeatureManager.isEnabledForAllUsers("azure.ad.additional.regions").orElse(false);
        Map<String, String> regions = Arrays.stream(DefaultRegion.values()).filter(region -> allRegions || !NON_DEFAULT_REGIONS.contains(region)).collect(Collectors.toMap(Enum::name, Enum::name));
        regions.put("CUSTOM", "CUSTOM");
        return regions;
    }

    @ModelAttribute(value="azureFilteringEnabled")
    public boolean isAzureFilteringEnabled() {
        return this.azureFilteringEnabledChecker.isEnabled() && this.azureFilteringEnabledChecker.isAccessible();
    }

    @ModelAttribute(value="regionsMap")
    public Map<String, Map<String, String>> getRegionsMap() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (DefaultRegion value : DefaultRegion.values()) {
            HashMap<String, String> regionMap = new HashMap<String, String>();
            regionMap.put("graphApiUrl", value.getGraphApiUrl());
            regionMap.put("basicAuthorityApiUrl", value.getBasicAuthorityApiUrl());
            result.put(value.name(), regionMap);
        }
        result.put("CUSTOM", (Map<String, String>)ImmutableMap.of((Object)"graphApiUrl", (Object)"", (Object)"basicAuthorityApiUrl", (Object)""));
        return result;
    }

    boolean hasAdvancedConfigOptions(@Nullable AzureAdDirectoryConfiguration configuration) {
        AzureAdDirectoryConfiguration defaults = new AzureAdDirectoryConfiguration();
        return configuration != null && !new EqualsBuilder().append(configuration.isGroupFilteringEnabled(), defaults.isGroupFilteringEnabled()).append(configuration.getPollingIntervalInMin(), defaults.getPollingIntervalInMin()).append((Object)configuration.getPollerConfig().getSynchronisationType(), (Object)defaults.getPollerConfig().getSynchronisationType()).append((Object)configuration.getCronExpression(), (Object)defaults.getCronExpression()).append(configuration.getReadTimeoutInSec(), defaults.getReadTimeoutInSec()).append(configuration.getConnectionTimeoutInSec(), defaults.getConnectionTimeoutInSec()).append((Object)configuration.getGroupSyncOnAuthMode(), (Object)defaults.getGroupSyncOnAuthMode()).append(configuration.isIncrementalSyncEnabled(), defaults.isIncrementalSyncEnabled()).isEquals();
    }

    @PostMapping
    public final ModelAndView onSubmit(HttpServletRequest request, @Valid @ModelAttribute(value="configuration") AzureAdDirectoryConfiguration configuration, BindingResult errors) {
        return this.handleSubmit(request, configuration, errors);
    }

    @ModelAttribute
    public void addAttributes(Model model) {
        model.addAttribute("hasAdvancedConfigOptionsSet", () -> {
            AzureAdDirectoryConfiguration configuration = (AzureAdDirectoryConfiguration)model.getAttribute("configuration");
            return this.hasAdvancedConfigOptions(configuration);
        });
    }

    @Override
    protected AzureAdDirectoryConfiguration createConfigurationFromRequest(HttpServletRequest request) throws Exception {
        if (this.directoryContextHelper.hasDirectoryId(request)) {
            Directory directory = this.directoryContextHelper.getDirectory(request);
            return this.directoryMapper.toAzureAdConfiguration(directory);
        }
        return new AzureAdDirectoryConfiguration();
    }

    @Override
    protected Directory createDirectory(AzureAdDirectoryConfiguration configuration) {
        return this.directoryMapper.buildAzureAdDirectory(configuration);
    }

    @Override
    protected String getFormView() {
        return FORM_VIEW;
    }

    @Override
    protected String getSuccessView() {
        return SUCCESS_VIEW;
    }
}

