/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.jndi;

import com.atlassian.crowd.directory.ldap.LdapPoolType;
import com.atlassian.crowd.embedded.admin.jndi.JndiLdapConnectionPoolPropertiesValidator;
import com.atlassian.crowd.embedded.admin.util.HtmlEncoder;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.ConnectionPoolPropertyUtil;
import com.atlassian.crowd.embedded.impl.EnvironmentUtils;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableSet;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/configure/connection-pool/**"})
public class JndiLdapConnectionPoolController {
    public static final String CONNECTION_POOL_FORM_VIEW = "connection-pool-form";
    public static final String CONNECTION_POOL_PROPERTIES = "poolProperties";
    public static final String JNDI_DIRECTORIES = "jndiDirectories";
    @Autowired
    private CrowdDirectoryService crowdDirectoryService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private I18nResolver i18nResolver;
    @Autowired
    private HtmlEncoder htmlEncoder;
    @Autowired
    private DirectoryManager directoryManager;

    @InitBinder(value={"poolProperties"})
    protected void initConnectionPoolPropertiesValidator(WebDataBinder binder) {
        binder.setValidator((Validator)new JndiLdapConnectionPoolPropertiesValidator());
    }

    @ModelAttribute(value="systemPoolProperties")
    public ConnectionPoolProperties getSystemPoolProperties() {
        return this.crowdDirectoryService.getSystemConnectionPoolProperties();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String initializeForm(ModelMap model) {
        model.addAttribute(CONNECTION_POOL_PROPERTIES, (Object)this.crowdDirectoryService.getStoredConnectionPoolProperties());
        model.addAttribute(JNDI_DIRECTORIES, this.getJndiDirectories());
        model.addAttribute("hideUpdateForm", (Object)this.isJre8());
        return CONNECTION_POOL_FORM_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView saveSettings(@Valid @ModelAttribute(value="poolProperties") JndiConnectionPoolPropertiesFormValues formValues, BindingResult errors) {
        Map model = errors.getModel();
        if (errors.hasErrors()) {
            ConnectionPoolProperties currentValues = this.revertInvalidValues(formValues, errors);
            model.put(CONNECTION_POOL_PROPERTIES, currentValues);
        } else {
            this.saveLdapProperties(formValues);
            model.put("saveSuccessful", true);
        }
        model.put(JNDI_DIRECTORIES, this.getJndiDirectories());
        return new ModelAndView(CONNECTION_POOL_FORM_VIEW, model);
    }

    private void saveLdapProperties(ConnectionPoolProperties poolProperties) {
        this.transactionTemplate.execute(() -> {
            this.crowdDirectoryService.setConnectionPoolProperties(poolProperties);
            return null;
        });
    }

    private ConnectionPoolProperties revertInvalidValues(JndiConnectionPoolPropertiesFormValues formValues, BindingResult errors) {
        ConnectionPoolProperties storedConfiguration = this.crowdDirectoryService.getStoredConnectionPoolProperties();
        errors.getFieldErrors().stream().map(FieldError::getField).forEach(errField -> {
            switch (errField) {
                case "initialSize": {
                    formValues.setInitialSize(storedConfiguration.getInitialSize());
                    break;
                }
                case "preferredSize": {
                    formValues.setPreferredSize(storedConfiguration.getPreferredSize());
                    break;
                }
                case "maximumSize": {
                    formValues.setMaximumSize(storedConfiguration.getMaximumSize());
                    break;
                }
                case "timeoutInSec": {
                    formValues.setTimeoutInSec(storedConfiguration.getTimeoutInSec());
                    break;
                }
                case "supportedProtocol": {
                    formValues.setSupportedProtocol(storedConfiguration.getSupportedProtocol());
                    break;
                }
                case "supportedAuthentication": {
                    formValues.setSupportedAuthentication(storedConfiguration.getSupportedAuthentication());
                    break;
                }
            }
        });
        errors.addError(new ObjectError(CONNECTION_POOL_PROPERTIES, this.i18nResolver.getText("embedded.crowd.connection.pool.save.fail")));
        return formValues;
    }

    @ModelAttribute(value="htmlEncoder")
    public HtmlEncoder getHtmlEncoder() {
        return this.htmlEncoder;
    }

    private List<Directory> getJndiDirectories() {
        return this.directoryManager.searchDirectories(DirectoryQueries.allDirectories().withSearchRestriction((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatchingAny((Collection)ImmutableSet.of((Object)DirectoryType.CONNECTOR, (Object)DirectoryType.DELEGATING)), Restriction.on((Property)DirectoryTermKeys.ACTIVE).exactlyMatching((Object)true)}))).stream().filter(directory -> LdapPoolType.fromString((String)((String)directory.getAttributes().get("ldap.pool.type"))) == LdapPoolType.JNDI).collect(Collectors.toList());
    }

    private boolean isJre8() {
        return EnvironmentUtils.getJreVersion().filter(arg_0 -> EnvironmentUtils.JRE.JRE_8.equals(arg_0)).isPresent();
    }

    public static class JndiConnectionPoolPropertiesFormValues
    implements ConnectionPoolProperties {
        private String initialSize;
        private String maximumSize;
        private String preferredSize;
        private String timeoutInSec;
        private String supportedAuthentication;
        private String supportedProtocol;

        public String getInitialSize() {
            return this.initialSize;
        }

        public String getMaximumSize() {
            return this.maximumSize;
        }

        public String getPreferredSize() {
            return this.preferredSize;
        }

        public String getTimeoutInSec() {
            return this.timeoutInSec;
        }

        public String getSupportedAuthentication() {
            return this.supportedAuthentication;
        }

        public String getSupportedProtocol() {
            return this.supportedProtocol;
        }

        public void setInitialSize(String initialSize) {
            this.initialSize = initialSize;
        }

        public void setMaximumSize(String maximumSize) {
            this.maximumSize = maximumSize;
        }

        public void setPreferredSize(String preferredSize) {
            this.preferredSize = preferredSize;
        }

        public void setTimeoutInSec(String timeoutInSec) {
            this.timeoutInSec = timeoutInSec;
        }

        public void setSupportedAuthentication(String supportedAuthentication) {
            this.supportedAuthentication = supportedAuthentication;
        }

        public void setSupportedProtocol(String supportedProtocol) {
            this.supportedProtocol = supportedProtocol;
        }

        public Map<String, String> toPropertiesMap() {
            HashMap<String, String> atrributesMap = new HashMap<String, String>();
            atrributesMap.put("com.sun.jndi.ldap.connect.pool.initsize", this.getInitialSize());
            atrributesMap.put("com.sun.jndi.ldap.connect.pool.maxsize", this.getMaximumSize());
            atrributesMap.put("com.sun.jndi.ldap.connect.pool.prefsize", this.getPreferredSize());
            atrributesMap.put("com.sun.jndi.ldap.connect.pool.timeout", ConnectionPoolPropertyUtil.secondsToMillis((String)this.getTimeoutInSec()));
            atrributesMap.put("com.sun.jndi.ldap.connect.pool.protocol", this.getSupportedProtocol());
            atrributesMap.put("com.sun.jndi.ldap.connect.pool.authentication", this.getSupportedAuthentication());
            return atrributesMap;
        }
    }
}

