/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.rest;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.embedded.admin.DirectoryMapper;
import com.atlassian.crowd.embedded.admin.crowd.CrowdDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.dto.CrowdUserSyncPreviewRequest;
import com.atlassian.crowd.embedded.admin.dto.LdapUserSyncPreviewRequest;
import com.atlassian.crowd.embedded.admin.dto.UserSyncPreviewResult;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.service.UserSyncPreviewService;
import com.atlassian.crowd.embedded.admin.util.PasswordRestoreUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

@Path(value="/preview-users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SystemAdminOnly
public class UserPreviewResource {
    private final UserSyncPreviewService userSyncPreviewService;
    private final DirectoryMapper directoryMapper;
    private final PasswordRestoreUtil passwordRestoreUtil;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public UserPreviewResource(UserSyncPreviewService userSyncPreviewService, DirectoryMapper directoryMapper, PasswordRestoreUtil passwordRestoreUtil) {
        this.userSyncPreviewService = userSyncPreviewService;
        this.directoryMapper = directoryMapper;
        this.passwordRestoreUtil = passwordRestoreUtil;
    }

    @POST
    @Path(value="/ldap")
    public Response getLdapUserPreviewResult(InputStream requestBody) throws Exception {
        LdapUserSyncPreviewRequest request = (LdapUserSyncPreviewRequest)this.objectMapper.readValue(requestBody, LdapUserSyncPreviewRequest.class);
        LdapDirectoryConfiguration configuration = request.getDirectoryConfiguration();
        Directory directory = this.directoryMapper.buildLdapDirectory(configuration);
        Directory directoryWithPassword = this.passwordRestoreUtil.restoreOldPasswordIfNewIsEmpty(configuration, directory);
        UserSyncPreviewResult userPreviewResult = this.userSyncPreviewService.getUserPreviewResult(directoryWithPassword, request);
        return Response.ok((Object)userPreviewResult).build();
    }

    @POST
    @Path(value="/crowd")
    public Response getCrowdUserPreviewResult(InputStream requestBody) throws Exception {
        CrowdUserSyncPreviewRequest request = (CrowdUserSyncPreviewRequest)this.objectMapper.readValue(requestBody, CrowdUserSyncPreviewRequest.class);
        CrowdDirectoryConfiguration configuration = request.getDirectoryConfiguration();
        Directory directory = this.directoryMapper.buildCrowdDirectory(configuration);
        Directory directoryWithPassword = this.passwordRestoreUtil.restoreOldPasswordIfNewIsEmpty(configuration, directory);
        UserSyncPreviewResult userPreviewResult = this.userSyncPreviewService.getUserPreviewResult(directoryWithPassword, request);
        return Response.ok((Object)userPreviewResult).build();
    }

    @VisibleForTesting
    void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

