/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.upgrade;

import com.atlassian.crowd.directory.synchronisation.Defaults;
import com.atlassian.crowd.embedded.admin.DelegatedDirectoryFinder;
import com.atlassian.crowd.embedded.admin.util.SimpleMessage;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask005_AddDefaultLDAPTimeoutsToDelegatedDirectories
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask005_AddDefaultLDAPTimeoutsToDelegatedDirectories.class);
    private static final int BUILD_NUMBER = 5;
    private static final String SHORT_DESCRIPTION = "Add default LDAP timeouts to Delegated directories";
    private static final ImmutableMap<String, String> DEFAULT_TIMEOUTS = ImmutableMap.of((Object)"ldap.connection.timeout", (Object)String.valueOf(Defaults.CONNECTION_TIMEOUT.toMillis()), (Object)"ldap.read.timeout", (Object)String.valueOf(Defaults.READ_TIMEOUT.toMillis()), (Object)"ldap.search.timelimit", (Object)String.valueOf(Defaults.SEARCH_TIMEOUT.toMillis()));
    private final DelegatedDirectoryFinder delegatedDirectoryFinder;
    private final DirectoryManager directoryManager;

    public UpgradeTask005_AddDefaultLDAPTimeoutsToDelegatedDirectories(DelegatedDirectoryFinder delegatedDirectoryFinder, DirectoryManager directoryManager) {
        this.delegatedDirectoryFinder = delegatedDirectoryFinder;
        this.directoryManager = directoryManager;
    }

    public int getBuildNumber() {
        return 5;
    }

    @Nonnull
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.crowd.embedded.admin";
    }

    @Nullable
    public Collection<Message> doUpgrade() {
        ImmutableList.Builder errorsAndWarnings = ImmutableList.builder();
        this.delegatedDirectoryFinder.findDirectories().forEach(directory -> {
            HashMap<String, String> newAttributes = new HashMap<String, String>(directory.getAttributes());
            DEFAULT_TIMEOUTS.forEach(newAttributes::putIfAbsent);
            if (newAttributes.size() != directory.getAttributes().size()) {
                this.updateDirectory((Directory)directory, (Map<String, String>)newAttributes, (ImmutableList.Builder<Message>)errorsAndWarnings);
            }
        });
        return errorsAndWarnings.build();
    }

    private void updateDirectory(Directory directory, Map<String, String> attributes, ImmutableList.Builder<Message> errorsAndWarnings) {
        ImmutableDirectory directoryToUpdate = ImmutableDirectory.builder((Directory)directory).setAttributes(attributes).build();
        try {
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
        catch (Exception e) {
            log.warn("Could not update LDAP timeout attributes with default values for directory {}", (Object)directory, (Object)e);
            errorsAndWarnings.add((Object)SimpleMessage.instance("embedded.crowd.update.directory.error", new Serializable[]{directory, e.getMessage()}));
        }
    }
}

