/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.upgrade;

import com.atlassian.crowd.directory.cache.AzureGroupFilterProcessor;
import com.atlassian.crowd.embedded.admin.util.SimpleMessage;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask006_TrimWhitespacesFromAzureAdFilteredGroups
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask006_TrimWhitespacesFromAzureAdFilteredGroups.class);
    private static final int BUILD_NUMBER = 6;
    private static final String SHORT_DESCRIPTION = "Trims whitespaces from Group Names from the list of Azure AD Filtered Groups.";
    private final DirectoryManager directoryManager;

    public UpgradeTask006_TrimWhitespacesFromAzureAdFilteredGroups(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public int getBuildNumber() {
        return 6;
    }

    @Nonnull
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.crowd.embedded.admin";
    }

    @Nullable
    public Collection<Message> doUpgrade() {
        ImmutableList.Builder errorsAndWarnings = ImmutableList.builder();
        EntityQuery directoryEntityQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.AZURE_AD)).returningAtMost(-1);
        this.directoryManager.searchDirectories(directoryEntityQuery).forEach(directory -> this.setDirectoryAttributes((Directory)directory, (ImmutableList.Builder<Message>)errorsAndWarnings));
        return errorsAndWarnings.build();
    }

    private void setDirectoryAttributes(Directory directory, ImmutableList.Builder<Message> errorsAndWarnings) {
        String groupsToFilterAttribute = directory.getValue("AZURE_AD_FILTERED_GROUPS");
        Set originalSet = AzureGroupFilterProcessor.getGroupNames((String)groupsToFilterAttribute);
        Set trimmedSet = originalSet.stream().map(String::trim).collect(Collectors.toSet());
        try {
            if (!originalSet.equals(trimmedSet)) {
                String trimmedGroupsToFilterAttribute = AzureGroupFilterProcessor.prepareAttribute(trimmedSet);
                ImmutableDirectory newDirectory = ImmutableDirectory.builder((Directory)directory).setAttribute("AZURE_AD_FILTERED_GROUPS", trimmedGroupsToFilterAttribute).build();
                this.directoryManager.updateDirectory((Directory)newDirectory);
                log.info("Successfully trimmed whitespaces from filtered groups for directory '{}' [{}]", (Object)directory.getName(), (Object)directory.getId());
            }
        }
        catch (Exception e) {
            log.error("Could not set directory attributes {} [{}]", new Object[]{directory.getName(), directory.getId(), e});
            errorsAndWarnings.add((Object)SimpleMessage.instance("embedded.crowd.update.directory.error", new Serializable[]{directory, e.getMessage()}));
        }
    }
}

