/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.remote.RemoteEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public final class ListenerEventClassExtractor {
    private static final Class<EventListener> ANNOTATION_CLASS = EventListener.class;

    public static Set<Class> getRemoteEventClasses(Object listener) {
        return Arrays.stream(listener.getClass().getMethods()).filter(ListenerEventClassExtractor::isValidMethod).map(m -> m.getParameterTypes()[0]).collect(Collectors.toUnmodifiableSet());
    }

    private static boolean isValidMethod(Method method) {
        return ListenerEventClassExtractor.isAnnotated(method) && ListenerEventClassExtractor.hasValidParameter(method);
    }

    private static boolean isAnnotated(Method method) {
        return method.getAnnotation(ANNOTATION_CLASS) != null;
    }

    private static boolean hasValidParameter(Method method) {
        return method.getParameterTypes().length == 1 && RemoteEvent.class.isAssignableFrom(method.getParameterTypes()[0]) && RemoteEvent.getCapability(method.getParameterTypes()[0]) != null;
    }
}

