/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.impl.ListenerEventClassExtractor;
import com.atlassian.event.remote.internal.json.SerializationRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteEventCapabilityRegistrar {
    private final ListenerEventClassExtractor eventClassExtractor;
    private final Set<Object> registeredListeners;
    private final SerializationRegistrar serializationRegistrar;
    private volatile ResettableLazyReference<Set<String>> publishedRegisteredCapabilities;
    private volatile ResettableLazyReference<Map<String, Class<? extends RemoteEvent>>> registeredCapabilities;

    @Autowired
    public RemoteEventCapabilityRegistrar(ListenerEventClassExtractor eventClassExtractor, @ComponentImport SerializationRegistrar serializationRegistrar) {
        this.eventClassExtractor = eventClassExtractor;
        this.serializationRegistrar = serializationRegistrar;
        this.registeredListeners = Collections.newSetFromMap(new ConcurrentHashMap());
        this.registeredCapabilities = new ResettableLazyReference<Map<String, Class<? extends RemoteEvent>>>(){

            protected Map<String, Class<? extends RemoteEvent>> create() throws Exception {
                return RemoteEventCapabilityRegistrar.this.createRegisteredCapabilities();
            }
        };
        this.publishedRegisteredCapabilities = new ResettableLazyReference<Set<String>>(){

            protected Set<String> create() throws Exception {
                return RemoteEventCapabilityRegistrar.this.createPublishedRegisteredCapabilities();
            }
        };
    }

    public Set<String> getCapabilities() {
        return ((Map)this.registeredCapabilities.get()).keySet();
    }

    public Class<? extends RemoteEvent> getCapabilityClass(String capability) {
        return (Class)((Map)this.registeredCapabilities.get()).get(capability);
    }

    public Set<String> getPublishedCapabilities() {
        return (Set)this.publishedRegisteredCapabilities.get();
    }

    public Set<Object> getRegisteredListeners() {
        return this.registeredListeners;
    }

    public boolean isRegistered(String capability) {
        return ((Map)this.registeredCapabilities.get()).containsKey(capability);
    }

    public synchronized void register(Object listener) {
        Set<Class> remoteEventClasses = ListenerEventClassExtractor.getRemoteEventClasses(listener);
        this.registeredListeners.add(listener);
        this.serializationRegistrar.register(remoteEventClasses);
        this.invalidateRegisteredCapabilities();
    }

    public synchronized void unregister(Object listener) {
        if (this.registeredListeners.remove(listener)) {
            this.serializationRegistrar.unregister(ListenerEventClassExtractor.getRemoteEventClasses(listener));
            for (Object o : this.registeredListeners) {
                this.serializationRegistrar.register(ListenerEventClassExtractor.getRemoteEventClasses(o));
            }
            this.invalidateRegisteredCapabilities();
        }
    }

    public void unregisterAll() {
        this.registeredListeners.clear();
        this.invalidateRegisteredCapabilities();
    }

    private void addIfNewOrSuperClass(Set<Class> set, Class e) {
        boolean skip = false;
        ArrayList<Class> toReplace = new ArrayList<Class>();
        for (Class other : set) {
            if (e.isAssignableFrom(other)) {
                toReplace.add(other);
                continue;
            }
            if (!other.isAssignableFrom(e)) continue;
            skip = true;
            break;
        }
        set.removeAll(toReplace);
        if (!skip) {
            set.add(e);
        }
    }

    private Map<String, Class<? extends RemoteEvent>> createRegisteredCapabilities() {
        HashMap<String, Class> capabilities = new HashMap<String, Class>();
        for (Object listener : this.registeredListeners) {
            for (Class eventClass : ListenerEventClassExtractor.getRemoteEventClasses(listener)) {
                capabilities.put(RemoteEvent.getCapability((Class)eventClass), eventClass);
            }
        }
        return Collections.unmodifiableMap(capabilities);
    }

    private Set<String> createPublishedRegisteredCapabilities() {
        HashSet<Class> classesToPublish = new HashSet<Class>();
        for (Object listener : this.registeredListeners) {
            for (Class eventClass : ListenerEventClassExtractor.getRemoteEventClasses(listener)) {
                this.addIfNewOrSuperClass(classesToPublish, eventClass);
            }
        }
        return classesToPublish.stream().map(RemoteEvent::getCapability).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    private void invalidateRegisteredCapabilities() {
        this.publishedRegisteredCapabilities.reset();
        this.registeredCapabilities.reset();
    }
}

