/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.gpg;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;
import org.hibernate.validator.constraints.Length;

public class AddGpgKeyRequest {
    private final String keyText;
    private final ApplicationUser user;

    private AddGpgKeyRequest(Builder builder) {
        this.keyText = builder.keyText;
        this.user = Objects.requireNonNull(builder.user, "user");
    }

    @Length(max=250000, message="{bitbucket.service.gpg.key.too.large}")
    @NotBlank(message="{bitbucket.service.gpg.key.not.provided}")
    public @Length(max=250000, message="{bitbucket.service.gpg.key.too.large}") @NotBlank(message="{bitbucket.service.gpg.key.not.provided}") String getKeyText() {
        return this.keyText;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder
    extends BuilderSupport {
        private String keyText;
        private ApplicationUser user;

        @Nonnull
        public AddGpgKeyRequest build() {
            return new AddGpgKeyRequest(this);
        }

        @Nonnull
        public Builder keyText(@Nullable String value) {
            this.keyText = value;
            return this;
        }

        @Nonnull
        public Builder user(@Nonnull ApplicationUser value) {
            this.user = Objects.requireNonNull(value, "user");
            return this;
        }
    }
}

