/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.DataStoreException;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.gpg.AddGpgKeyRequest;
import com.atlassian.bitbucket.gpg.DuplicateGpgKeyException;
import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgKeyCreatedEvent;
import com.atlassian.bitbucket.gpg.GpgKeyDeletedEvent;
import com.atlassian.bitbucket.gpg.InvalidGpgKeyException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.gpg.InternalGpgKeyService;
import com.atlassian.bitbucket.internal.gpg.SimpleGpgKey;
import com.atlassian.bitbucket.internal.gpg.bc.SignatureUtil;
import com.atlassian.bitbucket.internal.gpg.dao.AoGpgKey;
import com.atlassian.bitbucket.internal.gpg.dao.GpgKeyDao;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.java.ao.ActiveObjectsException;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGpgKeyService
implements InternalGpgKeyService {
    private static final int KEY_ID_LENGTH = 16;
    private static final Logger log = LoggerFactory.getLogger(DefaultGpgKeyService.class);
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final GpgKeyDao keyDao;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final Validator validator;

    public DefaultGpgKeyService(EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, GpgKeyDao keyDao, TransactionTemplate transactionTemplate, UserService userService, Validator validator) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.keyDao = keyDao;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
        this.validator = validator;
    }

    @Override
    @Nonnull
    public List<GpgKey> addKeys(@Nonnull AddGpgKeyRequest request) {
        Set violations = this.validator.validate((Object)Objects.requireNonNull(request, "request"), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        ApplicationUser user = Objects.requireNonNull(request, "request").getUser();
        this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
        try {
            List<GpgKey> keys = SignatureUtil.parseGpgKeyRing(request.getKeyText());
            if (keys.isEmpty()) {
                throw new InvalidGpgKeyException(this.i18nService.createKeyedMessage("bitbucket.service.gpg.key.not.provided", new Object[0]));
            }
            return (List)this.transactionTemplate.execute(() -> {
                ImmutableList.Builder result = ImmutableList.builder();
                try {
                    for (GpgKey key : keys) {
                        AoGpgKey existing = this.keyDao.findByFingerprint(key.getFingerprint()).orElse(null);
                        if (existing != null) {
                            boolean ownerInactive;
                            ApplicationUser owner = existing.getUserId().intValue() == user.getId() ? user : this.userService.getUserById(existing.getUserId().intValue(), true);
                            boolean bl = ownerInactive = owner == null || !owner.isActive();
                            if (ownerInactive || ApplicationUserEquality.equals((ApplicationUser)owner, (Object)user)) {
                                if (ownerInactive) {
                                    log.info("Deleting stale GPG key with ID {} for inactive user {}", (Object)Long.toHexString(existing.getId()), (Object)(owner == null ? "<missing>" : owner.getName()));
                                }
                                this.keyDao.delete(existing);
                                this.eventPublisher.publish((Object)new GpgKeyDeletedEvent(this, this.fromAoKey(existing)));
                            } else {
                                throw new DuplicateGpgKeyException(this.i18nService.createKeyedMessage("bitbucket.service.gpg.key.duplicate", new Object[0]));
                            }
                        }
                        GpgKey newKey = this.fromAoKey(this.keyDao.create(new SimpleGpgKey.Builder(key).user(user).build()));
                        this.eventPublisher.publish((Object)new GpgKeyCreatedEvent(this, newKey));
                        result.add((Object)newKey);
                    }
                }
                catch (ActiveObjectsException e) {
                    log.error("Unable to persist GPG key", (Throwable)e);
                    throw new DataStoreException(this.i18nService.createKeyedMessage("bitbucket.service.gpg.key.db.create.failed", new Object[0]), (Throwable)e);
                }
                return result.build();
            });
        }
        catch (IOException | PGPRuntimeOperationException e) {
            throw new InvalidGpgKeyException(this.getDetailedMessage(e), e);
        }
    }

    @Override
    public int deleteAllForUser(@Nonnull ApplicationUser user) {
        this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
        return (Integer)this.transactionTemplate.execute(() -> this.keyDao.deleteAllForUser(user.getId()));
    }

    @Override
    public boolean deleteById(@Nonnull String fingerprintOrId) {
        Objects.requireNonNull(fingerprintOrId, "fingerprintOrId");
        this.permissionValidationService.validateAuthenticated();
        return (Boolean)this.transactionTemplate.execute(() -> {
            if (fingerprintOrId.length() == 16) {
                long keyId = Long.parseUnsignedLong(fingerprintOrId, 16);
                List<AoGpgKey> keys = this.keyDao.findByKeyId(keyId);
                AuthorisationException authorisationException = null;
                for (AoGpgKey key : keys) {
                    try {
                        ApplicationUser user = this.userService.getUserById(key.getUserId().intValue(), true);
                        if (user == null) continue;
                        this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
                        this.keyDao.delete(key);
                        this.eventPublisher.publish((Object)new GpgKeyDeletedEvent(this, this.fromAoKey(key)));
                        return true;
                    }
                    catch (AuthorisationException e) {
                        authorisationException = e;
                    }
                }
                if (authorisationException != null) {
                    throw authorisationException;
                }
                return false;
            }
            AoGpgKey key = this.keyDao.findByFingerprint(fingerprintOrId).orElse(null);
            if (key != null) {
                this.permissionValidationService.validateForUser(this.getUserForKey(key), Permission.USER_ADMIN);
                this.keyDao.delete(key);
                this.eventPublisher.publish((Object)new GpgKeyDeletedEvent(this, this.fromAoKey(key)));
                return true;
            }
            return false;
        });
    }

    @Override
    @Nonnull
    public Page<GpgKey> findAllForUser(@Nonnull ApplicationUser user, @Nonnull PageRequest pageRequest) {
        return (Page)this.transactionTemplate.execute(() -> {
            this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
            return this.keyDao.findByUser(user, pageRequest).transform(aoGpgKey -> this.fromAoKey((AoGpgKey)aoGpgKey, user));
        });
    }

    @Override
    @Nullable
    public ApplicationUser getUserForKey(@Nonnull String fingerprintOrId) {
        Objects.requireNonNull(fingerprintOrId, "fingerprintOrId");
        this.permissionValidationService.validateAuthenticated();
        return (ApplicationUser)this.transactionTemplate.execute(() -> {
            ApplicationUser user;
            if (fingerprintOrId.length() == 16) {
                long keyId = Long.parseUnsignedLong(fingerprintOrId, 16);
                List<AoGpgKey> keys = this.keyDao.findByKeyId(keyId);
                for (AoGpgKey key : keys) {
                    ApplicationUser user2 = this.userService.getUserById(key.getUserId().intValue(), true);
                    if (user2 == null) continue;
                    return user2;
                }
                return null;
            }
            AoGpgKey key = this.keyDao.findByFingerprint(fingerprintOrId).orElse(null);
            if (key != null && (user = this.getUserForKey(key)) != null) {
                return user;
            }
            return null;
        });
    }

    @Override
    @Nonnull
    public List<GpgKey> findById(long keyId) {
        return (List)this.transactionTemplate.execute(() -> (List)this.keyDao.findByKeyId(keyId).stream().map(this::fromAoKey).collect(MoreCollectors.toImmutableList()));
    }

    @EventListener
    public void onUserCleanup(@Nonnull UserCleanupEvent event) {
        Page keys;
        while (!(keys = (Page)this.transactionTemplate.execute(() -> {
            Page<AoGpgKey> page = this.keyDao.findByUser(event.getDeletedUser(), PageUtils.newRequest((int)0, (int)250));
            for (AoGpgKey key : page.getValues()) {
                this.keyDao.delete(key);
                this.eventPublisher.publish((Object)new GpgKeyDeletedEvent(this, this.fromAoKey(key)));
            }
            return page;
        })).getIsLastPage()) {
        }
    }

    private GpgKey fromAoKey(AoGpgKey key) {
        return SimpleGpgKey.fromAoKey(key, this.getUserForKey(key));
    }

    private GpgKey fromAoKey(AoGpgKey key, ApplicationUser user) {
        return SimpleGpgKey.fromAoKey(key, user);
    }

    private KeyedMessage getDetailedMessage(Exception e) {
        if (e.getCause() != null && "unknown PGP public key algorithm encountered".equals(e.getCause().getMessage())) {
            return this.i18nService.createKeyedMessage("bitbucket.service.gpg.key.unsupported.algorithm", new Object[0]);
        }
        return this.i18nService.createKeyedMessage("bitbucket.service.gpg.key.invalid", new Object[0]);
    }

    private ApplicationUser getUserForKey(AoGpgKey key) {
        return this.userService.getUserById(key.getUserId().intValue(), true);
    }
}

