/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg;

import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgKeyService;
import com.atlassian.bitbucket.internal.gpg.PublicKeySupplier;
import com.atlassian.bitbucket.internal.gpg.bc.SignatureUtil;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPublicKeySupplier
implements PublicKeySupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultPublicKeySupplier.class);
    private final GpgKeyService keyService;

    public DefaultPublicKeySupplier(GpgKeyService keyService) {
        this.keyService = keyService;
    }

    @Override
    @Nonnull
    public Map<PGPPublicKey, ApplicationUser> getPublicKey(long keyId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List<GpgKey> keys = this.keyService.findById(keyId);
        for (GpgKey key : keys) {
            ApplicationUser user = key.getUser().orElse(null);
            if (user == null || !user.isActive()) continue;
            try {
                SignatureUtil.parsePublicKey(key.getKeyText(), keyId).ifPresent(pgpPubKey -> builder.put(pgpPubKey, (Object)user));
            }
            catch (PGPRuntimeOperationException e) {
                log.error("Error while parsing PGP public key for key ID {}", (Object)Long.toHexString(keyId), (Object)e);
                return Collections.emptyMap();
            }
        }
        return builder.build();
    }
}

