/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifier;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifierFactory;
import com.atlassian.bitbucket.internal.gpg.GpgSignatureVerifier;
import com.atlassian.bitbucket.internal.gpg.GpgSystemSigningKeyProvider;
import com.atlassian.bitbucket.internal.gpg.PublicKeySupplier;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.springframework.beans.factory.annotation.Qualifier;

public class GpgSignatureVerifierFactory
implements SignatureVerifierFactory {
    private final GpgSystemSigningKeyProvider gpgSystemSigningKeyProvider;
    private final ApplicationPropertiesService propertiesService;
    private final PublicKeySupplier publicKeySupplier;
    private final UserService userService;
    private final PGPContentVerifierBuilderProvider verifierBuilderProvider;

    public GpgSignatureVerifierFactory(GpgSystemSigningKeyProvider gpgSystemSigningKeyProvider, ApplicationPropertiesService propertiesService, PublicKeySupplier publicKeySupplier, UserService userService, @Qualifier(value="jcaPGPContentVerifierBuilderProvider") PGPContentVerifierBuilderProvider verifierBuilderProvider) {
        this.gpgSystemSigningKeyProvider = gpgSystemSigningKeyProvider;
        this.propertiesService = propertiesService;
        this.publicKeySupplier = publicKeySupplier;
        this.userService = userService;
        this.verifierBuilderProvider = verifierBuilderProvider;
    }

    @Nonnull
    public Optional<SignatureVerifier> createSignatureVerifier() {
        return Optional.of(new GpgSignatureVerifier(this.gpgSystemSigningKeyProvider, this.propertiesService, this.publicKeySupplier, this.userService, this.verifierBuilderProvider));
    }
}

