/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg;

import com.atlassian.bitbucket.dmz.systemsigning.DmzSystemSigningService;
import com.atlassian.bitbucket.dmz.systemsigning.SigningFormat;
import com.atlassian.bitbucket.dmz.systemsigning.SystemSigningKeyProvider;
import com.atlassian.bitbucket.internal.gpg.bc.SignatureUtil;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpgSystemSigningKeyProvider
implements SystemSigningKeyProvider {
    private static final Logger log = LoggerFactory.getLogger(GpgSystemSigningKeyProvider.class);
    private final String armoredPublicKey;
    private final PGPPublicKey publicKey;

    public GpgSystemSigningKeyProvider(SecurityService securityService, DmzSystemSigningService systemSigningService) {
        EscalatedSecurityContext withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "Retrieve system signing secret key for signature verification");
        this.publicKey = (PGPPublicKey)withSysAdmin.call(() -> systemSigningService.getSystemSigningSecretKey(SigningFormat.GPG).map(SignatureUtil::parsePublicKeyFromSecretKey).filter(Optional::isPresent).map(Optional::get).orElse(null));
        if (this.publicKey == null) {
            log.debug("There was no system signing key available. Verification of system signed Git objects will not be performed.");
            this.armoredPublicKey = null;
        } else {
            log.info("Using signing key with fingerprint {}", (Object)Hex.toHexString((byte[])this.publicKey.getFingerprint()));
            this.armoredPublicKey = SignatureUtil.parsePublicKeyToString(this.publicKey).orElse(null);
            if (this.armoredPublicKey == null) {
                log.debug("The armored public key was not able to be read. Viewing the public system signing key will be unavailable");
            }
        }
    }

    @Nonnull
    public Optional<String> getArmoredPublicKey() {
        return Optional.ofNullable(this.armoredPublicKey);
    }

    @Nonnull
    public Optional<PGPPublicKey> getPublicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    @Nonnull
    public SigningFormat getSigningFormat() {
        return SigningFormat.GPG;
    }
}

