/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg;

import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.internal.gpg.SimpleGpgSubKey;
import com.atlassian.bitbucket.internal.gpg.dao.AoGpgKey;
import com.atlassian.bitbucket.internal.gpg.dao.AoGpgSubKey;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SimpleGpgKey
implements GpgKey {
    private final String emailAddress;
    private final Date expiryDate;
    private final String fingerprint;
    private final long id;
    private final String keyText;
    private final List<GpgSubKey> subKeys;
    private final ApplicationUser user;

    private SimpleGpgKey(Builder builder) {
        this.emailAddress = builder.emailAddress;
        this.expiryDate = builder.expiryDate;
        this.fingerprint = StringUtils.lowerCase((String)Objects.requireNonNull(builder.fingerprint, "fingerprint"));
        this.id = Long.parseUnsignedLong(StringUtils.substring((String)this.fingerprint, (int)-16), 16);
        this.keyText = Objects.requireNonNull(builder.keyText, "keyText");
        this.subKeys = (List)builder.subKeys.values().stream().map(b -> b.masterKey(this).build()).collect(MoreCollectors.toImmutableList());
        this.user = builder.user;
    }

    @Nonnull
    static SimpleGpgKey fromAoKey(@Nonnull AoGpgKey key, @Nonnull ApplicationUser user) {
        Builder builder = new Builder().emailAddress(key.getEmailAddress()).expiryDate(key.getExpiryDate()).fingerprint(key.getFingerprint()).text(key.getKeyText()).user(user);
        for (AoGpgSubKey subKey : key.getSubKeys()) {
            builder.subKey(subKey.getFingerprint(), subKey.getExpiryDate());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(this.emailAddress);
    }

    @Override
    @Nonnull
    public Optional<Date> getExpiryDate() {
        return Optional.ofNullable(this.expiryDate);
    }

    @Override
    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getKeyText() {
        return this.keyText;
    }

    @Override
    @Nonnull
    public List<GpgSubKey> getSubKeys() {
        return this.subKeys;
    }

    @Override
    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public static class Builder
    extends BuilderSupport {
        private String emailAddress;
        private Date expiryDate;
        private String fingerprint;
        private String keyText;
        private Map<String, SimpleGpgSubKey.Builder> subKeys;
        private ApplicationUser user;

        public Builder() {
            this.subKeys = new LinkedHashMap<String, SimpleGpgSubKey.Builder>();
        }

        public Builder(@Nonnull GpgKey other) {
            Objects.requireNonNull(other, "other");
            this.emailAddress = other.getEmailAddress().orElse(null);
            this.expiryDate = other.getExpiryDate().orElse(null);
            this.fingerprint = other.getFingerprint();
            this.keyText = other.getKeyText();
            this.user = other.getUser().orElse(null);
            this.subKeys = new LinkedHashMap<String, SimpleGpgSubKey.Builder>();
            for (GpgSubKey subKey : other.getSubKeys()) {
                this.subKeys.putIfAbsent(subKey.getFingerprint(), new SimpleGpgSubKey.Builder(subKey));
            }
        }

        @Nonnull
        public SimpleGpgKey build() {
            return new SimpleGpgKey(this);
        }

        @Nonnull
        public Builder emailAddress(@Nullable String value) {
            this.emailAddress = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder expiryDate(@Nullable Date value) {
            this.expiryDate = value;
            return this;
        }

        @Nonnull
        public Builder fingerprint(@Nonnull String value) {
            this.fingerprint = Objects.requireNonNull(value, "fingerprint");
            return this;
        }

        @Nonnull
        public Builder subKey(@Nonnull String fingerprint, @Nullable Date expiryDate) {
            this.subKeys.putIfAbsent(fingerprint, new SimpleGpgSubKey.Builder().fingerprint(Builder.requireNonBlank((String)fingerprint, (String)"subKey.fingerprint")).expiryDate(expiryDate));
            return this;
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            this.keyText = Objects.requireNonNull(value, "text");
            return this;
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser value) {
            this.user = value;
            return this;
        }
    }
}

