/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg;

import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SimpleGpgSubKey
implements GpgSubKey {
    private final Date expiryDate;
    private final String fingerprint;
    private final long id;
    private final GpgKey masterKey;

    private SimpleGpgSubKey(Builder builder) {
        this.expiryDate = builder.expiryDate;
        this.fingerprint = StringUtils.lowerCase((String)Objects.requireNonNull(builder.fingerprint, "fingerprint"));
        this.masterKey = Objects.requireNonNull(builder.masterKey, "masterKey");
        this.id = Long.parseUnsignedLong(StringUtils.substring((String)this.fingerprint, (int)-16), 16);
    }

    @Override
    @Nonnull
    public Optional<Date> getExpiryDate() {
        return Optional.ofNullable(this.expiryDate);
    }

    @Override
    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public GpgKey getMasterKey() {
        return this.masterKey;
    }

    public static class Builder
    extends BuilderSupport {
        private Date expiryDate;
        private String fingerprint;
        private GpgKey masterKey;

        public Builder() {
        }

        public Builder(@Nonnull GpgSubKey other) {
            Objects.requireNonNull(other, "other");
            this.expiryDate = other.getExpiryDate().orElse(null);
            this.fingerprint = other.getFingerprint();
            this.masterKey = other.getMasterKey();
        }

        @Nonnull
        public SimpleGpgSubKey build() {
            return new SimpleGpgSubKey(this);
        }

        @Nonnull
        public Builder expiryDate(@Nullable Date value) {
            this.expiryDate = value;
            return this;
        }

        @Nonnull
        public Builder fingerprint(@Nonnull String value) {
            this.fingerprint = Objects.requireNonNull(value, "fingerprint");
            return this;
        }

        @Nonnull
        public Builder masterKey(@Nonnull GpgKey value) {
            this.masterKey = Objects.requireNonNull(value, "masterKey");
            return this;
        }
    }
}

