/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.audit;

import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.util.AuditUtils;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

class GpgAuditUtils {
    private GpgAuditUtils() {
        throw new UnsupportedOperationException(GpgAuditUtils.class.getName() + " should not be instantiated");
    }

    static String formatId(long id) {
        return Long.toHexString(id);
    }

    static String formatKeyText(String keyText) {
        return StringUtils.abbreviate((String)keyText, (int)256);
    }

    static String formatSubKey(GpgSubKey subKey) {
        LinkedHashMap<String, String> key = new LinkedHashMap<String, String>();
        subKey.getExpiryDate().ifPresent(date -> key.put("expiry-date", date.toString()));
        key.put("id", GpgAuditUtils.formatId(subKey.getId()));
        key.put("fingerprint", GpgAuditUtils.formatKeyText(subKey.getFingerprint()));
        return AuditUtils.toJson(key);
    }
}

