/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgKeyCreatedEvent;
import com.atlassian.bitbucket.gpg.GpgKeyDeletedEvent;
import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.internal.gpg.audit.GpgAuditUtils;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class GpgEventListener {
    @VisibleForTesting
    static final String ACTION_CREATED = "bitbucket.plugins.gpg.audit.action.gpgevent.created";
    @VisibleForTesting
    static final String ACTION_DELETED = "bitbucket.plugins.gpg.audit.action.gpgevent.deleted";
    @VisibleForTesting
    static final String ATTR_DATE = "bitbucket.plugins.gpg.audit.attribute.gpgevent.date";
    @VisibleForTesting
    static final String ATTR_EMAIL = "bitbucket.plugins.gpg.audit.attribute.gpgevent.email";
    @VisibleForTesting
    static final String ATTR_FINGERPRINT = "bitbucket.plugins.gpg.audit.attribute.gpgevent.fingerprint";
    @VisibleForTesting
    static final String ATTR_ID = "bitbucket.plugins.gpg.audit.attribute.gpgevent.id";
    @VisibleForTesting
    static final String ATTR_SUB_KEYS = "bitbucket.plugins.gpg.audit.attribute.gpgevent.subkeys";
    @VisibleForTesting
    static final String ATTR_TEXT = "bitbucket.plugins.gpg.audit.attribute.gpgevent.text";
    private final AuditService auditService;

    public GpgEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onGpgKeyCreatedEvent(GpgKeyCreatedEvent event) {
        this.auditGpgKeyEvent(event.getKey(), ACTION_CREATED);
    }

    @EventListener
    public void onGpgKeyDeletedEvent(GpgKeyDeletedEvent event) {
        this.auditGpgKeyEvent(event.getKey(), ACTION_DELETED);
    }

    private void auditGpgKeyEvent(GpgKey key, String action) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)action).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_FINGERPRINT, (String)key.getFingerprint()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TEXT, (String)GpgAuditUtils.formatKeyText(key.getKeyText())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ID, (String)GpgAuditUtils.formatId(key.getId())).build());
        key.getEmailAddress().ifPresent(email -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EMAIL, (String)email).build()));
        key.getExpiryDate().ifPresent(date -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DATE, (String)date.toString()).build()));
        key.getUser().ifPresent(user -> builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)user)));
        GpgEventListener.addSubKeys(key, builder);
        this.auditService.audit(builder.build());
    }

    private static void addSubKeys(GpgKey key, AuditEvent.Builder builder) {
        List<GpgSubKey> subKeys = key.getSubKeys();
        if (!subKeys.isEmpty()) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SUB_KEYS, (String)subKeys.stream().map(GpgAuditUtils::formatSubKey).collect(Collectors.joining(", "))).build());
        }
    }
}

