/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.internal.gpg.dao.AoGpgKey;
import com.atlassian.bitbucket.internal.gpg.dao.AoGpgSubKey;
import com.atlassian.bitbucket.internal.gpg.dao.GpgKeyDao;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;

public class AoGpgKeyDao
extends AbstractAoDao
implements GpgKeyDao {
    public AoGpgKeyDao(@Nonnull ActiveObjects ao) {
        super(Objects.requireNonNull(ao, "ao"));
    }

    @Override
    @Nonnull
    public AoGpgKey create(@Nonnull GpgKey key) {
        ImmutableMap.Builder keyBuilder = ImmutableMap.builder().put((Object)"FINGERPRINT", (Object)StringUtils.lowerCase((String)key.getFingerprint())).put((Object)"KEY_ID", (Object)key.getId()).put((Object)"USER_ID", key.getUser().map(ApplicationUser::getId).orElse(null));
        key.getEmailAddress().ifPresent(email -> keyBuilder.put((Object)"EMAIL", email));
        key.getExpiryDate().ifPresent(date -> keyBuilder.put((Object)"EXPIRY_DATE", date));
        AoGpgKey aoKey = (AoGpgKey)this.ao.create(AoGpgKey.class, (Map)keyBuilder.build());
        aoKey.setKeyText(key.getKeyText());
        aoKey.save();
        for (GpgSubKey subKey : key.getSubKeys()) {
            ImmutableMap.Builder subKeyBuilder = ImmutableMap.builder().put((Object)"FK_GPG_KEY_ID", (Object)aoKey.getFingerprint()).put((Object)"KEY_ID", (Object)subKey.getId()).put((Object)"FINGERPRINT", (Object)subKey.getFingerprint());
            subKey.getExpiryDate().ifPresent(date -> subKeyBuilder.put((Object)"EXPIRY_DATE", date));
            this.ao.create(AoGpgSubKey.class, (Map)subKeyBuilder.build());
        }
        return (AoGpgKey)this.ao.get(AoGpgKey.class, (Object)key.getFingerprint());
    }

    @Override
    public void delete(@Nonnull AoGpgKey key) {
        for (AoGpgSubKey subKey : key.getSubKeys()) {
            this.ao.delete(new RawEntity[]{subKey});
        }
        this.ao.delete(new RawEntity[]{key});
    }

    @Override
    public int deleteAllForUser(int userId) {
        AoGpgKey[] keys;
        int count = 0;
        Query query = Query.select().where("USER_ID = ?", new Object[]{userId}).limit(250);
        do {
            for (AoGpgKey key : keys = (AoGpgKey[])this.ao.find(AoGpgKey.class, query)) {
                this.delete(key);
                ++count;
            }
        } while (keys.length == 250);
        return count;
    }

    @Override
    @Nonnull
    public Page<AoGpgKey> findAll(@Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoGpgKey.class, Query.select(), Objects.requireNonNull(pageRequest, "pageRequest"));
    }

    @Override
    @Nonnull
    public Optional<AoGpgKey> findByFingerprint(@Nonnull String fingerprint) {
        return Optional.ofNullable((AoGpgKey)this.ao.get(AoGpgKey.class, (Object)StringUtils.lowerCase((String)fingerprint)));
    }

    @Override
    @Nonnull
    public List<AoGpgKey> findByKeyId(long keyId) {
        ArrayList<AoGpgKey> result = new ArrayList<AoGpgKey>();
        result.addAll(this.findKeysById(keyId));
        result.addAll(this.findKeysBySubKeyId(keyId));
        return result;
    }

    @Override
    @Nonnull
    public Page<AoGpgKey> findByUser(@Nonnull ApplicationUser user, @Nonnull PageRequest pageRequest) {
        Query query = Query.select().where("USER_ID = ?", new Object[]{Objects.requireNonNull(user, "user").getId()});
        return this.pageQuery(AoGpgKey.class, query, Objects.requireNonNull(pageRequest, "pageRequest"));
    }

    private List<AoGpgKey> findKeysById(long keyId) {
        return Arrays.asList((AoGpgKey[])this.ao.find(AoGpgKey.class, Query.select().where("KEY_ID = ?", new Object[]{keyId})));
    }

    private List<AoGpgKey> findKeysBySubKeyId(long keyId) {
        Query where = Query.select().alias(AoGpgKey.class, "GpgKey").alias(AoGpgSubKey.class, "GpgSubKey").join(AoGpgSubKey.class, "GpgSubKey.FK_GPG_KEY_ID = GpgKey.FINGERPRINT").where("GpgKey.KEY_ID = ? OR GpgSubKey.KEY_ID = ?", new Object[]{keyId, keyId});
        return Arrays.asList((AoGpgKey[])this.ao.find(AoGpgKey.class, where));
    }
}

