/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.mvc;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.gpg.mvc.View;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class SoyView
implements View {
    private final AuthenticationContext authContext;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final String module;
    private final String template;

    public SoyView(AuthenticationContext authContext, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, SoyTemplateRenderer soyTemplateRenderer, String module, String template) {
        this.authContext = authContext;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.module = module;
        this.template = template;
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException, ServletException {
        resp.setContentType("text/html; charset=UTF-8");
        this.addXFrameHeader(resp);
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), this.module, this.template, model, this.getInjectedData(req, resp));
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private void addXFrameHeader(HttpServletResponse resp) throws IOException {
        resp.setHeader("X-Frame-Options", "SAMEORIGIN");
    }

    private Map<String, Object> getInjectedData(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> injectedData = new HashMap<String, Object>();
        injectedData.put("xsrfTokenName", this.xsrfTokenValidator.getXsrfParameterName());
        injectedData.put("xsrfTokenValue", this.xsrfTokenAccessor.getXsrfToken(req, resp, true));
        injectedData.put("principal", this.authContext.getCurrentUser());
        injectedData.put("productName", Product.NAME);
        return injectedData;
    }
}

