/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.gpg.AddGpgKeyRequest;
import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.gpg.InternalGpgKeyService;
import com.atlassian.bitbucket.internal.gpg.rest.RestGpgKey;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Tag(name="Security")
@LicensedOnly
@Path(value="keys")
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GpgKeyResource {
    private final AuthenticationContext authenticationContext;
    private final InternalGpgKeyService gpgKeyService;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final UserService userService;
    private final WebSudoManager webSudoManager;

    @Inject
    public GpgKeyResource(AuthenticationContext authenticationContext, InternalGpgKeyService gpgKeyService, I18nService i18nService, PermissionValidationService permissionValidationService, UserService userService, WebSudoManager webSudoManager) {
        this.authenticationContext = authenticationContext;
        this.gpgKeyService = gpgKeyService;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.userService = userService;
        this.webSudoManager = webSudoManager;
    }

    @Operation(description="Add a GPG key to the authenticated user's account. Optionally, users with ADMIN and higher permissions may choose to specify the <code>user</code> parameter to add a GPG key for another user.\n\nOnly authenticated users may call this endpoint.", summary="Create a GPG key")
    @Parameter(name="user", description="The name of the user to add a key for (optional; requires ADMIN permission or higher).", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="Response contains the GPG key that was just created.", representation=RestGpgKey.class, responseCode=200), @ResponseDoc(documentation="The request has failed validation.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to perform this operation.", responseCode=401, restError=true)})
    @RequestBody(description="The request body.", content={@Content(schema=@Schema(implementation=RestGpgKey.class))})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addKey(@QueryParam(value="user") String username, RestGpgKey gpgKey, @Context HttpServletRequest request) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser user = this.getUserByNameOrCurrent(username);
        this.checkWebSudo(user, request);
        List<GpgKey> keys = this.gpgKeyService.addKeys(new AddGpgKeyRequest.Builder().keyText(gpgKey.getText()).user(user).build());
        return Response.ok().entity(keys.stream().map(RestGpgKey::new).collect(MoreCollectors.toImmutableList())).build();
    }

    @Operation(description="Delete the GPG key with the specified ID or Key Fingerprint.", summary="Delete a GPG key")
    @Parameter(name="fingerprintOrId", description="The GPG fingerprint or ID.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The key has been deleted successfully.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to perform this operation.", responseCode=401, restError=true)})
    @DELETE
    @Path(value="/{fingerprintOrId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteKey(@PathParam(value="fingerprintOrId") String fingerprint, @Context HttpServletRequest request) {
        ApplicationUser userForKey = this.gpgKeyService.getUserForKey(fingerprint);
        if (userForKey != null) {
            this.checkWebSudo(userForKey, request);
        }
        this.gpgKeyService.deleteById(fingerprint);
        return Response.noContent().build();
    }

    @Operation(description="Delete all GPG keys for a supplied user.", summary="Delete all GPG keys for user")
    @Parameter(name="user", description="The username of the user to delete the keys for. If no username is specified, the GPG keys will be deleted for the currently authenticated user.", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="The GPG keys matching the supplied <strong>user</strong> were deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the GPG keys. This is only possible when a <strong>user</strong> is explicitly supplied.", responseCode=401, restError=true), @ResponseDoc(documentation="No user matches the supplied <strong>user</strong>.", responseCode=404, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteForUser(@QueryParam(value="user") String username, @Context HttpServletRequest request) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser user = this.getUserByNameOrCurrent(username);
        this.checkWebSudo(user, request);
        this.gpgKeyService.deleteAllForUser(user);
        return Response.noContent().build();
    }

    @Operation(description="Find all the keys for the currently authenticated user. Optionally, users with ADMIN and higher permissions may choose to specify the <code>user</code> parameter to retrieve GPG keys for another user.\n\nOnly authenticated users may call this endpoint.", summary="Get all GPG keys")
    @Parameter(name="user", description="The name of the user to get keys for (optional; requires ADMIN permission or higher).", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a paged response of of keys for the user.", paged=true, representation=RestGpgKey.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to perform this operation.", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getKeysForUser(@QueryParam(value="user") String username, @BeanParam PageRequestResolver pageRequestResolver, @Context HttpServletRequest request) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser user = this.getUserByNameOrCurrent(username);
        this.checkWebSudo(user, request);
        Page<GpgKey> keys = this.gpgKeyService.findAllForUser(user, pageRequestResolver.getPageRequest());
        return Response.ok().entity((Object)new RestPage(keys, RestGpgKey::new)).build();
    }

    private void checkWebSudo(ApplicationUser user, HttpServletRequest request) {
        if (user.getId() != this.authenticationContext.getCurrentUser().getId()) {
            this.permissionValidationService.validateForUser(user, Permission.USER_ADMIN);
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
    }

    private ApplicationUser getUserByNameOrCurrent(String username) {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (username != null) {
            user = this.userService.getUserByName(username);
            if (user == null) {
                user = this.userService.getServiceUserByName(username);
            }
            if (user == null) {
                throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.gpg.user.not.found", new Object[0]), username);
            }
        }
        return user;
    }
}

