/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.rest;

import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.internal.gpg.rest.RestGpgSubKey;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestGpgKey
extends RestMapEntity {
    private static final String EMAIL = "emailAddress";
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String FINGERPRINT = "fingerprint";
    private static final String ID = "id";
    private static final String SUB_KEYS = "subKeys";

    public RestGpgKey() {
    }

    public RestGpgKey(String emailAddress, String fingerprint, long id, Date expiryDate, List<GpgSubKey> subKeys) {
        this.putIfNotNull(FINGERPRINT, fingerprint);
        this.put(ID, StringUtils.leftPad((String)Long.toHexString(id), (int)16, (String)"0"));
        this.putIfNotNull(EMAIL, emailAddress);
        this.putIfNotNull(EXPIRY_DATE, expiryDate == null ? null : Long.valueOf(expiryDate.getTime()));
        this.put(SUB_KEYS, subKeys.stream().map(RestGpgSubKey::new).collect(MoreCollectors.toImmutableList()));
    }

    public RestGpgKey(GpgKey gpgKey) {
        this(gpgKey.getEmailAddress().orElse(null), gpgKey.getFingerprint(), gpgKey.getId(), gpgKey.getExpiryDate().orElse(null), gpgKey.getSubKeys());
    }

    private RestGpgKey(Map<String, Object> map) {
        super(map);
    }

    @Schema(example="bitbucket@example.com", accessMode=Schema.AccessMode.READ_ONLY)
    public String getEmailAddress() {
        return this.getStringProperty(EMAIL);
    }

    @Schema(example="61550496000000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getExpiryDate() {
        return this.getLongProperty(EXPIRY_DATE);
    }

    @Schema(example="43:51:43:a1:b5:fc:8b:b7:0a:3a:a9:b1:0f:66:73:a8", accessMode=Schema.AccessMode.READ_ONLY)
    public String getFingerprint() {
        return this.getStringProperty(FINGERPRINT);
    }

    @Schema(example="00000000000004d2", accessMode=Schema.AccessMode.READ_ONLY)
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Schema(example="[]", accessMode=Schema.AccessMode.READ_ONLY)
    public List<RestGpgSubKey> getSubKeys() {
        return (List)this.get(SUB_KEYS);
    }

    @Schema(example="-----BEGIN PGP SIGNATURE-----\n\niQEzBAABCAAdFiEEM8MrWnoxlp3K1lFY5BMGiWNefn4FAlkqKE4ACgkQ5BMGiWNe\nfn6/kggAyzKhDDqdVb3Rq02hiSqeqKa1JuKRqDmzIpa6Pxa+1CpCnxwaIVrGgIii\nvj0ZNJzL1Bm2xm0JasotJDiZq5pFKi0FfQ0WmskuhsW1VY/f08TltHpHvK2kHVRr\nGEMVDUb0nj0I7Duc8XTipiYoDGS1GvydNR/bu3SsFTcZyapXirQcTCRT6/Sn0/IP\npUeIwQo1qK4e8gTOhWhfWEiVig39lQhiZFtm5S/vfAY72/Rgp68zMYmwasMSnBgF\n/LLFW6lXAqZIoAP8AnmsMRjCH6mS98+/lxKq2+K71+2YUUIAnNEeO09Lufo3B3Da\nPbs7BpD28w4lKlzb2EQ0n0C9rrxdPA==\n=VZpm\n-----END PGP SIGNATURE-----\n", accessMode=Schema.AccessMode.WRITE_ONLY)
    public String getText() {
        return this.getStringProperty("text");
    }

    @Nullable
    public static RestGpgKey valueOf(@Nullable Object value) {
        if (value instanceof RestGpgKey) {
            return (RestGpgKey)((Object)value);
        }
        if (value instanceof GpgKey) {
            return new RestGpgKey((GpgKey)value);
        }
        if (value instanceof Map) {
            return new RestGpgKey((Map)value);
        }
        return null;
    }
}

