/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.rest;

import com.atlassian.bitbucket.gpg.GpgSubKey;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestGpgSubKey
extends RestMapEntity {
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String FINGERPRINT = "fingerprint";
    private static final String ID = "id";

    public RestGpgSubKey() {
    }

    public RestGpgSubKey(String fingerprint, long id, Date expiryDate) {
        this.putIfNotNull(FINGERPRINT, fingerprint);
        this.put(ID, StringUtils.leftPad((String)Long.toHexString(id), (int)16, (String)"0"));
        this.putIfNotNull(EXPIRY_DATE, expiryDate == null ? null : Long.valueOf(expiryDate.getTime()));
    }

    public RestGpgSubKey(GpgSubKey gpgSubKey) {
        this(gpgSubKey.getFingerprint(), gpgSubKey.getId(), gpgSubKey.getExpiryDate().orElse(null));
    }

    private RestGpgSubKey(Map<String, Object> map) {
        super(map);
    }

    public Date getExpiryDate() {
        return new Date(this.getLongProperty(EXPIRY_DATE));
    }

    public String getFingerprint() {
        return this.getStringProperty(FINGERPRINT);
    }

    @Nullable
    public static RestGpgSubKey valueOf(@Nullable Object value) {
        if (value instanceof RestGpgSubKey) {
            return (RestGpgSubKey)((Object)value);
        }
        if (value instanceof GpgSubKey) {
            return new RestGpgSubKey((GpgSubKey)value);
        }
        if (value instanceof Map) {
            return new RestGpgSubKey((Map)value);
        }
        return null;
    }
}

