/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.servlet;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.gpg.servlet.GpgServletConstants;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;

public abstract class GpgFormSupport {
    private final UserService userService;
    private final I18nService i18nService;

    protected GpgFormSupport(UserService userService, I18nService i18nService) {
        this.userService = userService;
        this.i18nService = i18nService;
    }

    protected ApplicationUser getUserFromRequest(HttpServletRequest req) {
        String userslug;
        ApplicationUser user = null;
        Matcher url = GpgServletConstants.ADD_KEY_FOR_USER_PATTERN.matcher(req.getPathInfo());
        if (url.matches() && (user = this.userService.getUserBySlug(userslug = url.group(1))) == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.plugins.gpg.admin.user.not.found", new Object[]{userslug}), userslug);
        }
        return user;
    }
}

