/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.servlet;

import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.gpg.GpgKey;
import com.atlassian.bitbucket.gpg.GpgKeyService;
import com.atlassian.bitbucket.internal.gpg.rest.RestGpgKey;
import com.atlassian.bitbucket.internal.gpg.servlet.GpgServletConstants;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GpgModelHelper
implements ContextProvider {
    private static final PageRequest DEFAULT_PAGE_REQUEST = PageUtils.newRequest((int)0, (int)50);
    private final UserService userService;
    private final NavBuilder navBuilder;
    private final GpgKeyService gpgKeyService;

    public GpgModelHelper(UserService userService, NavBuilder navBuilder, GpgKeyService gpgKeyService) {
        this.userService = userService;
        this.navBuilder = navBuilder;
        this.gpgKeyService = gpgKeyService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.convertToApplicationUser((Person)context.get("user"));
        String addKeyUrl = this.gpgServletPath("admin", "users", user.getSlug(), "keys", "add").buildRelative();
        Page<GpgKey> page = this.gpgKeyService.findAllForUser(user, DEFAULT_PAGE_REQUEST);
        return ImmutableMap.builder().put((Object)"user", (Object)user).put((Object)"addKeyUrl", (Object)addKeyUrl).put((Object)"page", (Object)new RestPage(page, RestGpgKey::new)).build();
    }

    public Map<String, Object> createKeysTableModel(ApplicationUser user) {
        String addKeyUrl = this.gpgServletPath("keys", "add").buildRelative();
        Page<GpgKey> page = this.gpgKeyService.findAllForUser(user, DEFAULT_PAGE_REQUEST);
        return ImmutableMap.builder().put((Object)"addKeyUrl", (Object)addKeyUrl).put((Object)"page", (Object)new RestPage(page, RestGpgKey::new)).build();
    }

    public Map<String, Object> createAddKeyFormModel(ApplicationUser user) {
        Object cancelUrl = this.gpgServletPath("keys").buildRelative();
        if (user != null) {
            cancelUrl = this.navBuilder.admin().users().view(user.getName()).buildRelative() + "#gpg";
        }
        return Collections.singletonMap("cancelUrl", cancelUrl);
    }

    public Map<String, Object> createAddKeyFormErrorModel(ApplicationUser user, String keyText, List<String> errorMessages) {
        return ImmutableMap.builder().putAll(this.createAddKeyFormModel(user)).put((Object)"text", (Object)keyText).put((Object)"fieldErrors", (Object)ImmutableMap.builder().put((Object)"text", errorMessages).build()).build();
    }

    private NavBuilder.PathBuilder<NavBuilder.PluginServlets> gpgServletPath(String ... path) {
        return this.navBuilder.pluginServlets().path((Path)new SimplePath(GpgServletConstants.GPG_BASE_PATH, path));
    }

    private ApplicationUser convertToApplicationUser(Person user) {
        return user instanceof ApplicationUser ? (ApplicationUser)user : this.userService.getUserByName(user.getName());
    }
}

