/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.servlet;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.internal.gpg.mvc.Controller;
import com.atlassian.bitbucket.internal.gpg.servlet.GpgServletConstants;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@LicensedOnly
public class GpgServlet
extends HttpServlet {
    private final PermissionValidationService permissionValidationService;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final NavBuilder navBuilder;
    private final Controller viewKeysController;
    private final Controller addKeyFormController;
    private final Controller submitKeyController;
    private final WebSudoManager webSudoManager;

    public GpgServlet(PermissionValidationService permissionValidationService, XsrfTokenValidator xsrfTokenValidator, NavBuilder navBuilder, Controller viewKeysController, Controller addKeyFormController, Controller submitKeyController, WebSudoManager webSudoManager) {
        this.permissionValidationService = permissionValidationService;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.navBuilder = navBuilder;
        this.viewKeysController = viewKeysController;
        this.addKeyFormController = addKeyFormController;
        this.submitKeyController = submitKeyController;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("/keys".equals(req.getPathInfo())) {
            this.permissionValidationService.validateAuthenticated();
            this.viewKeysController.handle(req, resp).render(req, resp);
        } else if ("/keys/add".equals(req.getPathInfo())) {
            this.permissionValidationService.validateAuthenticated();
            this.addKeyFormController.handle(req, resp).render(req, resp);
        } else if (GpgServletConstants.ADD_KEY_FOR_USER_PATTERN.matcher(req.getPathInfo()).matches()) {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            this.permissionValidationService.validateForGlobal(Permission.ADMIN);
            this.addKeyFormController.handle(req, resp).render(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("/keys/add".equals(req.getPathInfo())) {
            this.permissionValidationService.validateAuthenticated();
            if (this.validateXsrfToken(req, resp)) {
                this.submitKeyController.handle(req, resp).render(req, resp);
            }
        } else if (GpgServletConstants.ADD_KEY_FOR_USER_PATTERN.matcher(req.getPathInfo()).matches()) {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            this.permissionValidationService.validateForGlobal(Permission.ADMIN);
            if (this.validateXsrfToken(req, resp)) {
                this.submitKeyController.handle(req, resp).render(req, resp);
            }
        } else {
            resp.sendError(404);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (NoSuchEntityException e) {
            resp.sendError(404, e.getLocalizedMessage());
        }
        catch (AuthorisationException e) {
            resp.sendError(401, e.getLocalizedMessage());
        }
    }

    private boolean validateXsrfToken(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.xsrfTokenValidator.validateFormEncodedToken(req)) {
            req.getRequestDispatcher(this.navBuilder.xsrfNotification().buildRelNoContext()).forward((ServletRequest)req, (ServletResponse)resp);
            return false;
        }
        return true;
    }
}

