/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.gpg.servlet;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.gpg.AddGpgKeyRequest;
import com.atlassian.bitbucket.gpg.DuplicateGpgKeyException;
import com.atlassian.bitbucket.gpg.GpgKeyService;
import com.atlassian.bitbucket.gpg.InvalidGpgKeyException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.gpg.mvc.Controller;
import com.atlassian.bitbucket.internal.gpg.mvc.ModelAndView;
import com.atlassian.bitbucket.internal.gpg.mvc.RedirectView;
import com.atlassian.bitbucket.internal.gpg.mvc.ViewFactory;
import com.atlassian.bitbucket.internal.gpg.servlet.GpgFormSupport;
import com.atlassian.bitbucket.internal.gpg.servlet.GpgModelHelper;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GpgSubmitKeyController
extends GpgFormSupport
implements Controller {
    private final AuthenticationContext authContext;
    private final GpgKeyService gpgKeyService;
    private final NavBuilder navBuilder;
    private final GpgModelHelper modelHelper;
    private final ViewFactory viewFactory;

    public GpgSubmitKeyController(AuthenticationContext authContext, UserService userService, I18nService i18nService, GpgKeyService gpgKeyService, NavBuilder navBuilder, GpgModelHelper modelHelper, ViewFactory viewFactory) {
        super(userService, i18nService);
        this.authContext = authContext;
        this.gpgKeyService = gpgKeyService;
        this.navBuilder = navBuilder;
        this.modelHelper = modelHelper;
        this.viewFactory = viewFactory;
    }

    @Override
    public ModelAndView handle(HttpServletRequest req, HttpServletResponse resp) {
        Object viewKeysUrl;
        ApplicationUser user = this.getUserFromRequest(req);
        String keyText = req.getParameter("keyText");
        AddGpgKeyRequest.Builder addRequestBuilder = new AddGpgKeyRequest.Builder().keyText(keyText);
        if (user != null) {
            addRequestBuilder = addRequestBuilder.user(user);
            viewKeysUrl = this.navBuilder.admin().users().view(user.getName()).buildRelative() + "#gpg";
        } else {
            addRequestBuilder = addRequestBuilder.user(this.authContext.getCurrentUser());
            viewKeysUrl = this.navBuilder.pluginServlets().path(new String[]{"gpg", "keys"}).buildRelative();
        }
        try {
            this.gpgKeyService.addKeys(addRequestBuilder.build());
        }
        catch (ConstraintViolationException e) {
            return this.errorModelAndView(user, keyText, e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList()));
        }
        catch (DuplicateGpgKeyException | InvalidGpgKeyException e) {
            return this.errorModelAndView(user, keyText, Collections.singletonList(e.getLocalizedMessage()));
        }
        return new ModelAndView(new RedirectView(URI.create((String)viewKeysUrl)));
    }

    private ModelAndView errorModelAndView(ApplicationUser user, String keyText, List<String> errorMessages) {
        Map<String, Object> model = this.modelHelper.createAddKeyFormErrorModel(user, keyText, errorMessages);
        return new ModelAndView(this.viewFactory.createView("com.atlassian.bitbucket.server.bitbucket-gpg:gpg-frontend-resources", "bitbucketPluginGpg.internal.gpg.templates.gpgPages.addKey"), model);
    }
}

