/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.MalformedPacketException;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    LiteralDataPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(in, 11, newPacketFormat);
        this.format = in.read();
        int l = in.read();
        if (l < 0) {
            throw new MalformedPacketException("File name size cannot be negative.");
        }
        this.fileName = new byte[l];
        for (int i = 0; i != this.fileName.length; ++i) {
            int ch = in.read();
            if (ch < 0) {
                throw new IOException("literal data truncated in header");
            }
            this.fileName[i] = (byte)ch;
        }
        this.modDate = StreamUtil.readTime(in);
        if (this.modDate < 0L) {
            throw new IOException("literal data truncated in header");
        }
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray((byte[])this.fileName);
    }

    public byte[] getRawFileName() {
        return Arrays.clone((byte[])this.fileName);
    }
}

