/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Arrays;

public class RevocationKey
extends SignatureSubpacket {
    public RevocationKey(boolean isCritical, boolean isLongLength, byte[] data) {
        super(12, isCritical, isLongLength, data);
    }

    public RevocationKey(boolean isCritical, byte signatureClass, int keyAlgorithm, byte[] fingerprint) {
        super(12, isCritical, false, RevocationKey.createData(signatureClass, (byte)keyAlgorithm, fingerprint));
    }

    private static byte[] createData(byte signatureClass, byte keyAlgorithm, byte[] fingerprint) {
        byte[] data = new byte[2 + fingerprint.length];
        data[0] = signatureClass;
        data[1] = keyAlgorithm;
        System.arraycopy(fingerprint, 0, data, 2, fingerprint.length);
        return data;
    }

    public byte getSignatureClass() {
        return this.data[0];
    }

    public int getAlgorithm() {
        return this.data[1] & 0xFF;
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange((byte[])this.data, (int)2, (int)this.data.length);
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getFingerprint());
    }
}

